package com.moloco.sdk.internal

import android.net.Uri
import com.moloco.sdk.service_locator.SdkObjectFactory
import com.moloco.sdk.xenoss.sdkdevkit.android.persistenttransport.PersistentHttpRequest

internal interface BUrlTracker {
    operator fun invoke(burl: String)
}

internal fun BUrlTracker(): BUrlTracker = Instance

private val Instance by lazy {
    BUrlTrackerImpl(
        SdkObjectFactory.Network.persistentHttpRequestSingleton
    )
}

private class BUrlTrackerImpl(
    private val persistentHttpRequest: PersistentHttpRequest
) : BUrlTracker {

    override fun invoke(burl: String) {
        try {
            val preparedUrl = Uri.parse(burl)
            persistentHttpRequest.send(preparedUrl.toString())
        } catch (e: Exception) {
            MolocoLogger.error("BUrlTrackerImpl", e.toString())
        }
    }
}
