package com.moloco.sdk.internal

import com.moloco.sdk.publisher.MediationInfo
import io.ktor.http.HeadersBuilder
import java.lang.StringBuilder

internal fun HeadersBuilder.appendXMolocoUserAgent(
    molocoSdkVersion: String?,
    androidOSVersion: String?,
    mediationInfo: MediationInfo? = null,
) {
    val header = StringBuilder().apply {
        molocoSdkVersion?.let { append("MolocoSDK/$it;") }
        mediationInfo?.let { append("Mediator/${mediationInfo.name};") }
        androidOSVersion?.let { append("Android/$it;") }
    }.toString()

    append("X-Moloco-User-Agent", header)
}
