package com.moloco.sdk.internal

import com.moloco.sdk.xenoss.sdkdevkit.android.adrenderer.internal.vast.render.compose.OverrideVastContainerOnClick

// Converts Moloco Json ad rendering option (from bid response) "isAllAreaClickable" into
// OverrideVastContainerOnClick? for VastRenderer() composable.
// Once the backend supports different configs for different ad parts, this function will be updated.
// https://docs.google.com/document/d/1xKXq2ROM0cq7uVc18DAr9QAaZ6n0UG6tVMtgKBget5k/edit?userstoinvite=hongjai.cho@moloco.com&sharingaction=manageaccess&role=writer#heading=h.r54hwkzhlwm1
internal fun OverrideVastContainerOnClick(
    isAllAreaClickable: Boolean
): OverrideVastContainerOnClick? = if (isAllAreaClickable) null else NoOpLinearClicks


private val NoOpLinearClicks by lazy {
    OverrideVastContainerOnClick(
        overrideLinearOnClick = {},
    )
}

private val NoopClicks by lazy {
    OverrideVastContainerOnClick(
        overrideLinearOnClick = {},
        overrideCompanionOnClick = {},
        overrideDECOnClick = {}
    )
}
