package com.moloco.sdk.internal.client_metrics_data

/**
 * An enum to keep Count Events and their names in a place to follow data conventions downstream
 */
internal enum class AcmCount(val eventName: String) {
    /**
     * Initialization attempt count event. This is the SDK e2e init attempts (2 internal retries and one success will count as 1 attempt)
     */
    SDKInitAttempt("sdk_init_attempt"),

    /**
     * Initialization success count event
     */
    SDKInitSuccess("sdk_init_success"),

    /**
     * Initialization failure count event
     */
    SDKInitFailure("sdk_init_failure"),

    /**
     * Initialization attempt count event at request level (2 internal retries and 1 success will count as 3 attempts).
     */
    SDKPerformInitAttempt("sdk_perform_init_attempt"),

    /**
     * Initialization fetch count event at request level (2 internal retries and 1 success will count as 3 attempts).
     */
    SDKFetchInitAttempt("sdk_fetch_init_attempt"),

    /**
     * SDK init cache read status
     */
    SDKInitCacheRead("sdk_init_cache_read"),

    /**
     * SDK init cache write status
     */
    SDKInitCacheWrite("sdk_init_cache_write"),

    /**
     * SDK init cache clear status
     */
    SDKInitCacheClear("sdk_init_cache_clear"),

    /**
     * CreateXXX ad object result
     */
    CreateAd("create_ad"),

    /**
     * Captures number of load attempts started
     */
    LoadAdAttempt("load_ad_attempted"),

    /**
     * Load success count event
     */
    LoadAdSuccess("load_ad_success"),

    /**
     * Load failed count event
     */
    LoadAdFailed("load_ad_failed"),


    /**
     * Native Ad Load attempted count event
     */
    NativeAdLoadAdAttempted("native_ad_load_attempted"),

    /**
     * Native Ad Load success or failed count event
     */
    NativeLoadAd("native_ad_load"),

    /**
     * Bid Token get request from mediation
     */
    BidTokenGetRequest("bid_token_get_request"),

    /**
     * Bid Token get response from mediation
     */
    BidTokenGetResponse("bid_token_get_response"),

    /**
     * Token fetch count event. Can succeed or fail
     */
    BidTokenFetch("bid_token_fetch"),

    /**
     * BidToken duration that crossed 1s timeout threshold.
     * This is useful for AdMob as it has a 1s duration
     */
    BidTokenDurationTimeoutOneSecond("bid_token_duration_crossed_1s"),

    /**
     * BidToken duration that crossed 3s timeout threshold.
     * This is useful for MAX as it has a 3s duration
     */
    BidTokenDurationTimeoutThreeSecond("bid_token_duration_crossed_3s"),

    /**
     * Token fetch count event. Can succeed or fail
     */
    ServerBidTokenFetch("sbt_fetch"),

    /**
     * Captures whether client bid token used is cached or not
     */
    ServerBidTokenCached("sbt_cached"),

    /**
     * Token fetch HTTP count event. Can succeed or fail
     */
    ServerBidTokenApiFetch("sbt_api_fetch"),

    /**
     * Async Token fetch count event.
     */
    ServerBidTokenAsyncRefresh("sbt_async_fetch"),

    /**
     * Captures client bid token build event
     */
    ClientBidTokenBuild("bid_token_build"),

    /**
     * Captures whether client bid token used is cached or not
     */
    ClientBidTokenCached("cbt_cached"),

    /**
     * Captures number of show attempts started
     */
    ShowAdAttempt("show_ad_attempted"),

    /**
     * Show success count event
     */
    ShowAdSuccess("show_ad_success"),

    /**
     * Show failure count event
     */
    ShowAdFailed("show_ad_failed"),

    /**
     * Click count event
     */
    AdClicked("ad_clicked"),

    /**
     * Crash detected count event
     */
    CrashDetected("crash_detected");

    override fun toString(): String {
        return eventName
    }
}
