package com.moloco.sdk.internal.client_metrics_data

/**
 * An enum to keep reusable tags in a place to follow data conventions downstream.
 */
internal enum class AcmTag(val tagName: String) {
    /**
     * Tag to provide us the reason for a failure
     */
    Reason("reason"),

    /**
     * Tag to provide us the publisher level ad type
     */
    AdType("ad_type"),

    /**
     * Tag to provide a result for an event: success or failure
     */
    Result("result"),

    /**
     * Tag to provide a country for an event
     */
    Country("country"),

    /**
     * Tag to provide a retry count for an event: 1,2,3 etc
     */
    RetryAttempt("attempt"),

    /**
     * Tag to provide a step for an event for a multi step flow
     */
    Step("step"),
}


/**
 * An enum to keep reusable tag values in a place to follow data conventions downstream.
 * This is to ensure that common tag values are consistent (such as "failed" vs "failure" vs "fail").
 */
internal enum class AcmResultTag {
    success,
    failure;
}
