package com.moloco.sdk.internal.client_metrics_data

/**
 * An enum to keep Timer Events and their names in a place to follow data conventions downstream
 */
internal enum class AcmTimer(val eventName: String) {
    /**
     * Captures amount of time sdk initialization takes including any internal retries
     */
    SDKInit("sdk_init_time"),

    /**
     * Captures amount of time sdk initialization takes with breakdown of network fetch vs cache vs in memory
     */
    SDKPerformInitAttempt("sdk_perform_init_time_ms"),

    /**
     * Captures amount of time sdk initialization http request takes in ms
     */
    SDKInitHttpRequest("sdk_init_request_time_ms"),

    /**
     * Captures amount of time sdk initialization cache read takes in ms
     */
    SDKInitCacheRead("sdk_init_cache_read_time_ms"),

    /**
     * Captures amount of time sdk initialization cache write takes in ms
     */
    SDKInitCacheWrite("sdk_init_cache_write_time_ms"),

    /**
     * Captures amount of time sdk initialization cache clear takes in ms
     */
    SDKInitCacheClear("sdk_init_cache_clear_time_ms"),

    /**
     * Captures amount of time in createXX APIs
     */
    CreateAd("create_ad_time_ms"),

    /**
     * Captures amount of time it takes to await for the ad factory when createXX APIs are called
     */
    CreateAdAwaitAdFactory("create_ad_await_ad_factory_time_ms"),

    /**
     * Captures amount of time a load takes
     */
    LoadAd("load_ad_time"),

    /**
     * Captures amount of time a native ad load prepare takes
     */
    NativePrepareAd("native_ad_load_prepare_time"),

    /**
     * Captures bid token fetch time in ms including both server and client bid token fetch time
     */
    BidTokenFetch("bid_token_fetch_time"),

    /**
     * Captures bid token fetch time in ms including all retries
     */
    ServerBidTokenFetch("sbt_fetch_time_ms"),

    /**
     * Captures bid token fetch time in ms including for a sbt network request (no retries)
     */
    ServerBidTokenApiFetchTime("sbt_api_fetch_time_ms"),

    /**
     * Captures client bid token build time in ms
     */
    ClientBidTokenBuild("bid_token_build_time_ms"),

    /**
     * Captures from start of load call to start of show
     */
    LoadToShow("load_to_show_time"),


    /**
     * Captures from createXXX of adapter call to ad.load of adapter call
     */
    CreateToLoad("ad_create_to_load_ms");
    ;

    override fun toString(): String {
        return eventName
    }
}
