package com.moloco.sdk.internal.error.crash

import com.moloco.sdk.internal.scheduling.DispatcherProvider
import kotlinx.coroutines.withContext
import kotlin.system.exitProcess

/**
 * Crash detector service that can monitor for crashes and handle them
 */
interface CrashDetectorService {
    /**
     * Registers the exception handler that can monitor for application crashes
     */
    suspend fun register()
}

internal class CrashDetectorServiceImpl(
    private val crashHandler: CrashHandlerService
) : CrashDetectorService {
    private var oldHandler: Thread.UncaughtExceptionHandler? = null

    override suspend fun register() = withContext(DispatcherProvider().main) {
        if (oldHandler == null) {
            oldHandler = Thread.getDefaultUncaughtExceptionHandler()
            Thread.setDefaultUncaughtExceptionHandler { thread, throwable ->
                // handle crash reporting
                crashHandler.handleCrash(throwable)
                oldHandler?.uncaughtException(thread, throwable) ?: exitProcess(2)
            }
        }
    }
}
