package com.moloco.sdk.internal.error.crash.filters

import com.moloco.sdk.internal.MolocoLogger

/**
 * Moloco SDK exception filter that checks whether the exception is from the SDK or not
 */
class MolocoSDKExceptionFilter : ExceptionFilter {
    private val TAG = "MolocoSDKExceptionFilter"

    override fun apply(crash: Throwable): Boolean {
        // Java crashes should be included in the "cause" however for future proofing,
        // we will check both the reported throwable's stacktrace and cause's stacktrace
        crash.stackTrace.forEach { stackTraceElement ->
            if (stackTraceElement.className.contains("com.moloco.sdk")) {
                MolocoLogger.error(TAG, "SDK detected in stacktrace")
                return true
            } else {
                // NO OP
            }
        }

        val cause = crash.cause ?: return false
        cause.stackTrace.forEach { stackTraceElement ->
            if (stackTraceElement.className.contains("com.moloco.sdk")) {
                MolocoLogger.error(TAG, "SDK detected in stacktrace")
                return true
            } else {
                // NO OP
            }
        }

        return false
    }
}
