package com.moloco.sdk.internal.http

import com.moloco.sdk.BuildConfig
import com.moloco.sdk.internal.services.AppInfo
import com.moloco.sdk.internal.services.DeviceInfo
import com.moloco.sdk.publisher.MediationInfo
import com.moloco.sdk.publisher.Moloco
import com.moloco.sdk.xenoss.sdkdevkit.android.core.UserAgentService
import io.ktor.client.HttpClient
import io.ktor.client.plugins.HttpRequestRetry
import io.ktor.client.plugins.HttpTimeout
import io.ktor.client.plugins.UserAgent
import io.ktor.client.plugins.defaultRequest
import io.ktor.client.request.headers

internal fun buildHttpClient(appInfo: AppInfo, deviceInfo: DeviceInfo) =
    HttpClient {
        install(UserAgent) {
            agent = UserAgentService()()
        }
        install(HttpTimeout)
        install(HttpRequestRetry)

        defaultRequest {
            headers {
                append(
                    "X-Moloco-App-Info",
                    "AppBundle/${appInfo.packageName}; " +
                            "AppVersion/${appInfo.version}; " +
                            "AppKey/${Moloco.appKey};"
                )
                append(
                    "X-Moloco-Device-Info",
                    "make/${deviceInfo.manufacturer}; " +
                            "model/${deviceInfo.model}; " +
                            "hwv/${deviceInfo.hwVersion}; " +
                            "osv/${deviceInfo.osVersion}; " +
                            "OS/Android;"
                )

                val mediator = Moloco.mediationInfo?.let { "Mediator/${it.name};" } ?: ""
                append("X-Moloco-SDK-Info", "SdkVersion/${BuildConfig.SDK_VERSION_NAME}; $mediator")
            }
        }
    }