package com.moloco.sdk.internal.ortb

import com.moloco.sdk.internal.Json
import com.moloco.sdk.internal.Result
import com.moloco.sdk.internal.ortb.model.BidResponse
import com.moloco.sdk.internal.scheduling.DispatcherProvider
import kotlinx.coroutines.withContext
import kotlinx.serialization.decodeFromString
import kotlinx.serialization.json.Json

internal fun interface BidResponseParser {
    suspend operator fun invoke(bidResponseJson: String): Result<BidResponse, Exception>
}

internal fun BidResponseParser(): BidResponseParser = Instance

private val Instance: BidResponseParser by lazy {
    BidResponseParserImpl(
        Json()
    )
}

private class BidResponseParserImpl(private val json: Json) : BidResponseParser {
    private val dispatchers = DispatcherProvider()

    override suspend fun invoke(bidResponseJson: String): Result<BidResponse, Exception> =
        withContext(dispatchers.io) {
            try {
                Result.Success(
                    json.decodeFromString<BidResponse>(
                        bidResponseJson
                    ).substituteAuctionPriceMacros()
                )
            } catch (e: Exception) {
                Result.Failure(e)
            }
        }
}
