package com.moloco.sdk.internal.ortb.model

import kotlinx.serialization.SerialName
import kotlinx.serialization.Serializable

@Serializable
internal class SdkEvents(
    @SerialName("on_ad_load_start") val onAdLoadStart: String? = null,
    @SerialName("on_ad_load_failed") val onAdLoadFailed: String? = null,
    @SerialName("on_ad_load_success") val onAdLoadSuccess: String? = null,
    @SerialName("on_ad_show_failed") val onAdShowFailed: String? = null,
    @SerialName("on_ad_show_success") val onAdShowSuccess: String? = null,
    @SerialName("on_ad_clicked") val onAdClicked: String? = null,
    @SerialName("on_ad_hidden") val onAdHidden: String? = null,
    @SerialName("on_user_rewarded") val onUserRewarded: String? = null,
    @SerialName("on_rewarded_video_started") val onRewardedVideoStarted: String? = null,
    @SerialName("on_rewarded_video_completed") val onRewardedVideoCompleted: String? = null,
)

// In this scenario, all of the <String?> will be URL links that SDK should fire upon listener's events.

// SDK should append following query key-value to the links provided in the bid response upon availability:
//  - network_name = {{network_name}} (where {{network_name}} is resolved as netWorkName if available)
//  - error = {{error}} (if molocoAdError is available)
