package com.moloco.sdk.internal.publisher

import com.moloco.sdk.internal.MolocoLogger
import com.moloco.sdk.publisher.AdShowListener
import com.moloco.sdk.publisher.MolocoAd
import com.moloco.sdk.publisher.MolocoAdError

/**
 * Wraps the origin listener and fires url tracking event upon calling the respective listener's callback.
 */
internal fun AdShowListenerTracker(
    originListener: AdShowListener?,
): AdShowListener = AdShowListenerTrackerImpl(
    originListener,
)

private class AdShowListenerTrackerImpl(
    private val originListener: AdShowListener?,
) : AdShowListener {

    override fun onAdShowSuccess(molocoAd: MolocoAd) {
        MolocoLogger.debug(TAG, "onAdShowSuccess: $molocoAd")
        originListener?.onAdShowSuccess(molocoAd)
    }

    override fun onAdShowFailed(molocoAdError: MolocoAdError) {
        MolocoLogger.debug(TAG, "onAdShowFailed: $molocoAdError")
        originListener?.onAdShowFailed(molocoAdError)
    }

    override fun onAdHidden(molocoAd: MolocoAd) {
        MolocoLogger.debug(TAG, "onAdHidden: $molocoAd")
        originListener?.onAdHidden(molocoAd)
    }

    override fun onAdClicked(molocoAd: MolocoAd) {
        MolocoLogger.debug(TAG, "onAdClicked: $molocoAd")
        originListener?.onAdClicked(molocoAd)
    }

    companion object{
        private const val TAG = "AdShowListenerTrackerImpl"
    }
}

internal class BUrlData(val burl: String, val price: Float?)
