package com.moloco.sdk.internal.publisher.nativead.model

import com.moloco.sdk.xenoss.sdkdevkit.android.adrenderer.internal.errors.MolocoAdSubErrorType
import android.net.Uri
import com.moloco.sdk.xenoss.sdkdevkit.android.adrenderer.internal.vast.render.Ad

internal data class PreparedNativeAssets(
    private val data: Map<Int, PreparedNativeAsset.Data>,
    private val images: Map<Int, PreparedNativeAsset.Image>,
    private val titles: Map<Int, PreparedNativeAsset.Title>,
    private val videos: Map<Int, PreparedNativeAsset.Video>,
    private val failedAssets: List<Pair<NativeOrtbResponse.Asset, MolocoAdSubErrorType>>,
) {
    // Unused for now
    private val allNonFailedAssets by lazy {
        data + images + titles + videos
    }

    fun getTitlesFrom(id: Int) = titles[id]?.text

    fun getDataFrom(id: Int) = data[id]?.value

    fun getImageUriFor(id: Int) = images[id]?.precachedAssetUri

    fun getVastAdFor(id: Int)  = videos[id]?.vastAd
}

// Prepared asset via precaching or other means in order to be prepared for rendering.
internal sealed class PreparedNativeAsset(val originAsset: NativeOrtbResponse.Asset) {

    val id: Int = originAsset.id
    val required: Boolean = originAsset.required

    class Title(
        originAsset: NativeOrtbResponse.Asset.Title,
    ) : PreparedNativeAsset(originAsset) {

        val text: String = originAsset.text
    }

    class Image(
        originAsset: NativeOrtbResponse.Asset.Image,
        val precachedAssetUri: Uri,
    ) : PreparedNativeAsset(originAsset)

    class Video(
        originAsset: NativeOrtbResponse.Asset.Video,
        val vastAd: Ad,
    ) : PreparedNativeAsset(originAsset)

    class Data(
        originAsset: NativeOrtbResponse.Asset.Data,
    ) : PreparedNativeAsset(originAsset) {

        val value = originAsset.value
    }
}
