package com.moloco.sdk.internal.scheduling

import kotlinx.coroutines.CoroutineScope

object GlobalScopes {
    /**
     * Global Moloco SDK wide IO scope for coroutines that are fire and forget
     */
    val globalIOScope = CoroutineScope(DispatcherProvider().io)

    /**
     * Global Moloco SDK wide Default scope for coroutines that are fire and forget
     */
    val globalDefaultScope = CoroutineScope(DispatcherProvider().default)
}
