package com.moloco.sdk.internal.services

import android.content.Context
import android.content.pm.PackageInfo
import android.content.pm.PackageManager
import android.os.Build

internal interface AppInfoService {
    operator fun invoke(): AppInfo
}

internal class AppInfo(val applicationName: String, val packageName: String, val version: String)

internal class AppInfoServiceImpl(private val context: Context) : AppInfoService {

    private var appInfo: AppInfo? = null

    override fun invoke() = appInfo ?: kotlin.runCatching {
        val applicationName =
            with(context) { packageManager.getApplicationLabel(applicationInfo).toString() }
        context.getPackageInfo()
            .let { AppInfo(applicationName, it.packageName, it.versionName) }
            .also { appInfo = it }
    }.getOrNull() ?: AppInfo("", "", "")
}

@Suppress("DEPRECATION")
internal fun Context.getPackageInfo(): PackageInfo {
    return if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.TIRAMISU) {
        packageManager.getPackageInfo(packageName, PackageManager.PackageInfoFlags.of(0))
    } else {
        packageManager.getPackageInfo(packageName, 0)
    }
}
