package com.moloco.sdk.internal.services.bidtoken

import com.moloco.sdk.BidToken

internal typealias BidTokenString = String
internal typealias PublicKey = String

internal val DefaultBidTokenConfig = BidTokenConfig(dbtEnabled = false)
internal data class BidTokenConfig(
    val dbtEnabled: Boolean,
)

internal fun BidToken.BidTokenResponseV3.bidTokenConfig(): BidTokenConfig {
    return if (this.hasClientTokenConfigs()) {
        BidTokenConfig(
            dbtEnabled = this.clientTokenConfigs.enableDbt,
        )
    } else {
        DefaultBidTokenConfig
    }
}

internal val DefaultBidTokenResponseComponents = BidTokenResponseComponents(
    bidToken = "",
    publicKey = "",
    bidTokenConfig = DefaultBidTokenConfig,
)
internal data class BidTokenResponseComponents(
    val bidToken: BidTokenString,
    val publicKey: PublicKey,
    val bidTokenConfig: BidTokenConfig,
)
