package com.moloco.sdk.internal.services.bidtoken.providers

import com.moloco.sdk.internal.MolocoLogger
import com.moloco.sdk.internal.services.AccessibilityInfoService

internal data class AccessibilitySignal(
    val accessibilityCaptioningEnabled: Boolean? = null,
    val accessibilityLargePointerIcon: Boolean? = null,
    val reduceBrightColorsActivated: Boolean? = null,
    val fontScale: Float? = null,
)

internal class AccessibilitySignalProvider(
    private val accessibilityInfoService: AccessibilityInfoService,
): ClientBidTokenSignalProvider<AccessibilitySignal> {
    private var cachedSignal = getAccessibilitySignal()

    override fun needsRefresh(): Boolean {
        val currentSignal = getAccessibilitySignal()
        val needsRefresh = currentSignal != cachedSignal
        MolocoLogger.debugBuildLog(TAG, "[CBT] needsRefresh: $needsRefresh, with current: $currentSignal, cached: $cachedSignal")
        return needsRefresh
    }

    override fun tryUpdateSignalState() {
        cachedSignal = getAccessibilitySignal()
    }

    override fun provideSignal(): AccessibilitySignal {
        return cachedSignal
    }

    override fun logTag(): String = TAG

    private fun getAccessibilitySignal(): AccessibilitySignal {
        try {
            return AccessibilitySignal(
                accessibilityCaptioningEnabled = accessibilityInfoService.isAccessibilityCaptioningEnabled(),
                accessibilityLargePointerIcon = accessibilityInfoService.isLargePointerIconEnabled(),
                reduceBrightColorsActivated = accessibilityInfoService.isReduceBrightColorsActivated(),
                fontScale = accessibilityInfoService.getFontScale(),
            )
        } catch (e: Exception) {
            MolocoLogger.error(TAG, "[CBT] ACS Error", e)
            return AccessibilitySignal()
        }
    }

    companion object {
        private const val TAG = "AcSignalProvider"
    }
}
