package com.moloco.sdk.internal.services.init

internal enum class ClientFailureType {
    RequestTimeout,
    UnknownHostHttpError,
    HttpSocketError,
    HttpSslError,
    PersistentHttpUnavailableError,
    Unknown,
}

internal sealed class InitFailure {
    /**
     * Server errors are errors that are returned by the server as errors in the response.
     * A client was successfully able to complete a request and get a response (4xx, 5xx etc..)
     */
    class ServerError(val statusCode: Int) : InitFailure()

    /**
     * Client errors are errors that are caused by the client itself. (e.g. Request timeout, SSL error etc..)
     * In these cases, the client did not receive a response from the server.
     */
    class ClientError(val type: ClientFailureType) : InitFailure()
}