package com.moloco.sdk.internal.utils

private const val ERROR_CODE_MACRO = "[ERROR_CODE]"
internal fun String.substituteErrorMacro(errorCode: String): String {
    return this.replace(ERROR_CODE_MACRO, errorCode)
}

private const val TIMESTAMP_MACRO = "[HAPPENED_AT_TS]"
internal fun String.substituteTimestampMacro(timestamp: Long): String {
    return this.replace(TIMESTAMP_MACRO, timestamp.toString())
}

internal fun String.substituteErrorAndTimestampMacro(errorCode: String, timestamp: Long): String =
    substituteErrorMacro(errorCode).substituteTimestampMacro(timestamp)

internal fun String.substituteMTIDMacro(mtid: String?): String {
    return mtid?.run {this@substituteMTIDMacro.replace("[MTID]", mtid) } ?: this
}

/**
 * Macro for [com.moloco.sdk.xenoss.sdkdevkit.android.adrenderer.internal.ui.RewardedCountDownTimerCustom]
 */
private const val TIME_LEFT_MACRO = "[SECONDS_LEFT]"
internal fun String.substituteCountDownTimeLeftMacro(timeLeft: UInt): String {
    return this.replace(TIME_LEFT_MACRO, timeLeft.toString())
}
