package com.moloco.sdk.publisher

/**
 * Represents an interface for ad loading events
 */
interface AdLoad {

    /**
     * Property indicating if the ad is loaded
     */
    val isLoaded: Boolean

    /**
     * Loads the ad with the specified [bidResponseJson] and [listener].
     * If the ad is currently being displayed, the underlying ad object will be destroyed before loading a new one.
     *
     * @param bidResponseJson The ORTB auction response containing information such as ad markup "adm" (VAST, MRAID, HTML, etc.), extensions, etc.
     * @param listener The [Listener] instance that contains information about the ad load events
     */
    fun load(bidResponseJson: String, listener: Listener?)

    /**
     * Interface for ad load events
     */
    interface Listener {

        /**
         * Invoked when the ad is loaded successfully
         *
         * @param molocoAd The [MolocoAd] instance that contains information about the ad
         */
        fun onAdLoadSuccess(molocoAd: MolocoAd)

        /**
         * Invoked when an error occurs during ad loading
         *
         * @param molocoAdError The [MolocoAdError] instance that contains information about the error
         */
        fun onAdLoadFailed(molocoAdError: MolocoAdError)
    }
}
