package com.moloco.sdk.publisher

import android.app.Activity
import android.os.Bundle
import android.os.PersistableBundle
import com.moloco.sdk.publisher.MolocoAdError.AdCreateError

private class InterstitialAdActivitySample : Activity() {

    private lateinit var interstitialAd: InterstitialAd

    override fun onCreate(savedInstanceState: Bundle?, persistentState: PersistableBundle?) {
        super.onCreate(savedInstanceState, persistentState)

        // Once Moloco SDK is initialized, let's create an interstitial.
        Moloco.createInterstitial(
            adUnitId = "MOLOCO_ADUNIT_ID"
        ) { interstitialAd: InterstitialAd?, adCreateError: AdCreateError? ->
            if (interstitialAd == null) {
                // Weren't able to create interstitial due to Moloco SDK not initialized or invalid ad unit id.
                finish()
                return@createInterstitial
            }

            this.interstitialAd = interstitialAd

            // Fetch a bid response...

            // Load a successful bid response into interstitial object.
            // You can choose to listen to ad load events as well.
            interstitialAd.load(
                bidResponseJson = "bid response",
                listener = object : AdLoad.Listener {
                    override fun onAdLoadSuccess(molocoAd: MolocoAd) {
                        TODO("Not yet implemented")
                    }

                    override fun onAdLoadFailed(molocoAdError: MolocoAdError) {
                        TODO("Not yet implemented")
                    }
                }
            )

            // interstitial load status can also be checked by calling
            interstitialAd.isLoaded

            // Show ad when needed. You can also provide an optional ad show listener.
            interstitialAd.show(
                listener = object : InterstitialAdShowListener {
                    override fun onAdShowSuccess(molocoAd: MolocoAd) {
                        TODO("Not yet implemented")
                    }

                    override fun onAdShowFailed(molocoAdError: MolocoAdError) {
                        TODO("Not yet implemented")
                    }

                    override fun onAdHidden(molocoAd: MolocoAd) {
                        TODO("Not yet implemented")
                    }

                    override fun onAdClicked(molocoAd: MolocoAd) {
                        TODO("Not yet implemented")
                    }
                }
            )

            // In order to load an another interstitial, call load() method again with a new bid response.
            // load() call will force finish and hide the currently displaying ad.
            // For preloading another instance of ad in parallel, consider creating an another InterstitialAd instance.
            interstitialAd.load(bidResponseJson = "an_another_bid_response", listener = null)
        }

    }

    override fun onDestroy() {
        super.onDestroy()
        // Release resources when interstitial is not needed anymore and/or to prevent memory leaks;
        interstitialAd.destroy()
    }
}
