package com.moloco.sdk.publisher

/**
 * Data class representing a Moloco ad.
 *
 * @property networkName The name of the ad network.
 * @property adUnitId The id of the ad unit.
 */
data class MolocoAd(
    /**
     * Name of the network (Moloco)
     */
    val networkName: String,
    /**
     * The ad unit id
     */
    val adUnitId: String,
    /**
     * CPM price if available
     */
    val revenue: Float? = null,
)

/**
 * Creates a new [MolocoAd] object with [MolocoAd.networkName] set to "Moloco".
 *
 * @param adUnitId The id of the ad unit.
 * @return A new [MolocoAd] object with [MolocoAd.networkName] set to "Moloco".
 */
fun createAdInfo(adUnitId: String, revenue: Float? = null,): MolocoAd =
    MolocoAd("Moloco", adUnitId, revenue)
