package com.moloco.sdk.xenoss.sdkdevkit.android.adrenderer

import com.moloco.sdk.xenoss.sdkdevkit.android.adrenderer.internal.errors.MolocoAdSubErrorType

interface AdShowListener {
    fun onShowError(internalShowError: MolocoAdSubErrorType)
    fun onClick()
}

interface VastAdShowListener : AdShowListener {
    /**
     * VAST standard supports multiple ad scenes to display: most likely it's going to be a pair of video scene and endcard scene.
     * If each scene was "consumed" by the User without skipping, VAST ad can be considered "fully consumed"/completed.
     */
    fun onVastCompletionStatus(skipped: Boolean)
}

interface NativeAdShowListener : VastAdShowListener

interface AggregatedAdShowListener : VastAdShowListener
