package com.moloco.sdk.xenoss.sdkdevkit.android.adrenderer.internal

import android.annotation.SuppressLint
import android.content.Context
import android.view.Gravity
import com.moloco.sdk.service_locator.SdkObjectFactory
import com.moloco.sdk.xenoss.sdkdevkit.android.adrenderer.AdShowListener
import com.moloco.sdk.xenoss.sdkdevkit.android.adrenderer.CreativeType
import com.moloco.sdk.xenoss.sdkdevkit.android.adrenderer.Watermark
import com.moloco.sdk.xenoss.sdkdevkit.android.adrenderer.XenossBannerView
import com.moloco.sdk.xenoss.sdkdevkit.android.adrenderer.internal.errors.toMraidBannerError
import com.moloco.sdk.xenoss.sdkdevkit.android.adrenderer.internal.mraid.MraidBridge
import com.moloco.sdk.xenoss.sdkdevkit.android.adrenderer.internal.mraid.MraidInline
import com.moloco.sdk.xenoss.sdkdevkit.android.adrenderer.internal.ui.AdBadgeView
import com.moloco.sdk.xenoss.sdkdevkit.android.adrenderer.internal.ui.DEFAULT_PRIVACY_URL
import com.moloco.sdk.xenoss.sdkdevkit.android.adrenderer.internal.webview.BannerWebViewWrapper
import kotlinx.coroutines.CoroutineScope

@SuppressLint("ViewConstructor")
internal class MraidBannerView(
    private val context: Context,
    adm: String,
    externalLinkHandler: ExternalLinkHandler,
    private val watermark: Watermark,
    private val webViewWrapper: BannerWebViewWrapper = BannerWebViewWrapper(),
    scope: CoroutineScope
) : XenossBannerView<AdShowListener>(context, scope) {
    init {
        tag = "MolocoMraidBannerView"
    }

    override val creativeType: CreativeType = CreativeType.MRAID

    private val mraidInline = MraidInline(
        context,
        adm,
        onNeedToDetachAdViewBeforeExpand = this::detachMraidViewFromAdViewWrapper,
        onExpandAdViewClosed = this::attachMraidViewToAdViewWrapper,
        onClick = { adShowListener?.onClick() },
        onError = { adShowListener?.onShowError(it.toMraidBannerError()) },
        // TODO. https://youtrack.xenoss.io/issue/XFSDK-35
        // leave it blocked for now.
        forceBlockExpand = true,
        externalLinkHandler,
        mraidBridge = MraidBridge(context, scope)
    )

    override fun destroy() {
        super.destroy()
        mraidInline.destroy()
    }

    // As ugly as it gets.
    private fun detachMraidViewFromAdViewWrapper() {
        adView = null
    }

    // As ugly as it gets.
    private fun attachMraidViewToAdViewWrapper() {
        prepareAdViewForDisplay()
    }

    // Mraid banner can receive a null bid here because the adm is passed to MraidInline : MraidBaseAd
    // which loads the adm in the webview
    override val adLoader = MraidAdLoad(scope, bid = null, SdkObjectFactory.AdLoadModule.decLoader, mraidInline::loadAndReadyMraid)

    override fun prepareAdViewForDisplay() {
        adView = webViewWrapper.wrapWebView(context, mraidInline.webView).also {
            watermark.applyWatermark(it)
        }
    }
}
