package com.moloco.sdk.xenoss.sdkdevkit.android.adrenderer.internal

import java.net.URI
import java.security.MessageDigest

fun String.toMD5WithoutQueryParams(): String {
    val url = URI(this).run { URI(scheme, authority, path, null, fragment).toString() }

    val md = MessageDigest.getInstance("MD5")
    md.update(url.toByteArray())
    return md.digest().toHex()
}

fun String.toMD5(): String {
    val md = MessageDigest.getInstance("MD5")
    md.update(toByteArray())
    return md.digest().toHex()
}
