package com.moloco.sdk.xenoss.sdkdevkit.android.adrenderer.internal

import java.text.SimpleDateFormat
import java.util.Locale
import java.util.TimeZone

fun utcNowEpochMillis() = System.currentTimeMillis()

/**
 * Helper function around the Java's [SimpleDateFormat].
 * It returns a [SimpleDateFormat] object with locale set to English and timezone set to UTC
 */
fun createSimpleDateFormat(pattern: String) = SimpleDateFormat(pattern, Locale.ROOT)
    .apply {
        timeZone = TimeZone.getTimeZone("UTC")
    }
