package com.moloco.sdk.xenoss.sdkdevkit.android.adrenderer.internal.media

import java.io.IOException
import java.net.SocketException
import java.net.UnknownHostException
import java.security.cert.CertPathValidatorException
import java.security.cert.CertificateException
import javax.net.ssl.SSLHandshakeException

internal fun exceptionToMediaResult(e: Exception): MediaCacheRepository.Result.Failure {
    return when (e) {
        is UnknownHostException -> MediaCacheRepository.Result.Failure.UnknownHostHttpError
        is SocketException -> MediaCacheRepository.Result.Failure.HttpSocketError
        is SSLHandshakeException -> MediaCacheRepository.Result.Failure.HttpSslError
        is IOException -> MediaCacheRepository.Result.Failure.HttpDiskIOError
        is SecurityException -> MediaCacheRepository.Result.Failure.HttpDiskSecurityError
        is MediaFetchTimeoutException -> MediaCacheRepository.Result.Failure.MediaFetchTimeoutError
        is NumberFormatException -> MediaCacheRepository.Result.Failure.MediaFetchNumberParseError
        else -> MediaCacheRepository.Result.Failure.UnknownMediaFetchError
    }
}