package com.moloco.sdk.xenoss.sdkdevkit.android.adrenderer.internal.mraid

import android.content.Context
import android.webkit.WebView
import com.moloco.sdk.internal.Result
import com.moloco.sdk.xenoss.sdkdevkit.android.adrenderer.internal.ExternalLinkHandler
import com.moloco.sdk.xenoss.sdkdevkit.android.adrenderer.internal.errors.MraidAdError
import com.moloco.sdk.xenoss.sdkdevkit.android.adrenderer.internal.ui.ButtonRecorder
import com.moloco.sdk.xenoss.sdkdevkit.android.adrenderer.internal.ui.ButtonTracker
import com.moloco.sdk.xenoss.sdkdevkit.android.core.services.CustomUserEventBuilderService

internal class MraidInline(
    context: Context,
    adm: String,
    private val onNeedToDetachAdViewBeforeExpand: () -> Unit,
    private val onExpandAdViewClosed: () -> Unit,
    onClick: () -> Unit,
    onError: (MraidAdError) -> Unit,
    // TODO. Refactor. Workaround for mraid endcard not crashing Vast player.
    forceBlockExpand: Boolean,
    externalLinkHandler: ExternalLinkHandler,
    mraidBridge: MraidBridge,
    private val buttonTracker: ButtonTracker = ButtonTracker(),
) : MraidBaseAd(
    context,
    adm,
    MraidPlacementType.Inline,
    onClick,
    onError,
    externalLinkHandler,
    forceBlockExpand,
    mraidBridge,
), ButtonRecorder {

    // TODO. Refactor whole MRAID.
    val webView: WebView
        get() = mraidBridge.webView

    suspend fun load(): WebView? {
        // error/load callbacks are already inside. I know, I know...
        return if (loadAndReadyMraid() is Result.Success) {
            mraidBridge.webView
        } else {
            null
        }
    }

    override fun onPreExpandAd() {
        super.onPreExpandAd()
        onNeedToDetachAdViewBeforeExpand()
    }

    override fun closeFullscreenAdRepresentation() {
        super.closeFullscreenAdRepresentation()
        onExpandAdViewClosed()
    }

    override fun onButtonRendered(button: CustomUserEventBuilderService.UserInteraction.Button) {
        buttonTracker.onButtonRendered(button)
    }

    override fun onButtonUnRendered(buttonType: CustomUserEventBuilderService.UserInteraction.Button.ButtonType) {
        buttonTracker.onButtonUnRendered(buttonType)
    }
}
