package com.moloco.sdk.xenoss.sdkdevkit.android.adrenderer.internal.mraid

import android.content.Context
import android.graphics.Rect
import android.view.View
import com.moloco.sdk.internal.scheduling.DispatcherProvider
import com.moloco.sdk.xenoss.sdkdevkit.android.adrenderer.Destroyable
import kotlinx.coroutines.CoroutineScope
import kotlinx.coroutines.Job
import kotlinx.coroutines.delay
import kotlinx.coroutines.flow.MutableStateFlow
import kotlinx.coroutines.flow.StateFlow
import kotlinx.coroutines.launch
import kotlinx.coroutines.plus

// TODO. Doesn't do initial layout pass/calculation in ctor.
//  It doesn't matter really, since the view is still not attached to the window/activity
//  during this class instance creation.
//  Just keep that in mind.
internal class MraidViewVisualMetricsTracker(
    private val view: View,
    context: Context,
    scope: CoroutineScope,
) : Destroyable {

    private val _scope = scope + DispatcherProvider().main

    // TODO. Predraw, INVISIBLE visibility tracking: INVISIBLE doesn't trigger layout update.
    //  Also Banner impression uses the same type of logic, but without debounce btw, less performant.

    private var updateJob: Job? = null

    private val layoutChangeListener =
        View.OnLayoutChangeListener { _, left, top, right, bottom, _, _, _, _ ->
            updateJob?.cancel()
            updateJob = _scope.launch {
                // Sort of like optimization to avoid frequent layout change recalculations.
                // If I used flows, I would just use debounce.
                // StateFlow might already cancel stuff due to inherent skipping nature.
                // TODO. Check the written above.
                delay(200)

                updateVisibility()
                updateRects(left, top, right, bottom)
            }
        }

    init {
        view.addOnLayoutChangeListener(layoutChangeListener)
    }

    override fun destroy() {
        updateJob?.cancel()
        view.removeOnLayoutChangeListener(layoutChangeListener)
    }

    private val _isVisible = MutableStateFlow(false)
    val isVisible: StateFlow<Boolean> = _isVisible

    private fun updateVisibility() {
        _isVisible.value = view.isShown
    }

    private val _screenMetrics = MraidScreenMetrics(context)
    private val _screenMetricsEvent = MutableStateFlow(MraidScreenMetricsEvent(_screenMetrics))
    val screenMetricsEvent: StateFlow<MraidScreenMetricsEvent> = _screenMetricsEvent

    // Happens on main thread, so no problem with multi-thread access to the same MraidScreenMetrics instance.
    private fun updateRects(left: Int, top: Int, right: Int, bottom: Int) {
        // Why not creating an another one?
        val rect = Rect(left, top, right, bottom)

        val width = rect.width()
        val height = rect.height()

        // TODO. Currently I use the same values all around,
        //  change accordingly for the proper banner "resize" command  support.
        with(_screenMetrics) {
            setCurrentAdPosition(left, top, width, height)
            setDefaultAdPosition(left, top, width, height)
            setRootViewPosition(left, top, width, height)
            setScreenSize(width, height)
        }

        _screenMetricsEvent.value = MraidScreenMetricsEvent(_screenMetrics)
    }

    // TODO. Remove once MraidScreenMetrics is refactored.
    // In short, StateFlow doesn't fire updates since Object.equals in these case is always true.
    // Therefore let's use wrapper over MraidScreenMetrics instance.
    class MraidScreenMetricsEvent(val value: MraidScreenMetrics)
}
