package com.moloco.sdk.xenoss.sdkdevkit.android.adrenderer.internal.ui

import androidx.compose.foundation.background
import androidx.compose.foundation.clickable
import androidx.compose.foundation.interaction.MutableInteractionSource
import androidx.compose.foundation.layout.Box
import androidx.compose.foundation.layout.size
import androidx.compose.material.Icon
import androidx.compose.material.MaterialTheme
import androidx.compose.material.ripple.rememberRipple
import androidx.compose.runtime.Composable
import androidx.compose.runtime.remember
import androidx.compose.ui.Alignment
import androidx.compose.ui.Modifier
import androidx.compose.ui.draw.clip
import androidx.compose.ui.graphics.Color
import androidx.compose.ui.graphics.RectangleShape
import androidx.compose.ui.graphics.Shape
import androidx.compose.ui.graphics.painter.Painter
import androidx.compose.ui.res.painterResource
import androidx.compose.ui.semantics.Role
import androidx.compose.ui.tooling.preview.Preview
import androidx.compose.ui.unit.DpSize
import androidx.compose.ui.unit.dp
import com.moloco.sdk.R
import com.moloco.sdk.xenoss.sdkdevkit.android.adrenderer.internal.ui.theme.Theme
import com.moloco.sdk.xenoss.sdkdevkit.android.adrenderer.internal.ui.utils.DEFAULT_BUTTON_DP_SIZE
import com.moloco.sdk.xenoss.sdkdevkit.android.adrenderer.internal.ui.utils.DEFAULT_ICON_BUTTON_BACKGROUND_COLOR
import com.moloco.sdk.xenoss.sdkdevkit.android.adrenderer.internal.ui.utils.DEFAULT_ICON_BUTTON_BACKGROUND_SHAPE

/**
 * @param tint - tint to be applied to painter. If Color.Unspecified is provided, then no tint is applied
 */
@Composable
fun GenericIconButton(
    painter: Painter,
    onClick: () -> Unit,
    modifier: Modifier = Modifier,
    enabled: Boolean = true,
    contentDescription: String? = null,
    tint: Color = MaterialTheme.colors.primary,
    // TODO. Move to external Modifier caller?
    size: DpSize = DEFAULT_BUTTON_DP_SIZE,
    iconSize: DpSize = size,
    backgroundShape: Shape = DEFAULT_ICON_BUTTON_BACKGROUND_SHAPE,
    backgroundColor: Color = DEFAULT_ICON_BUTTON_BACKGROUND_COLOR
) {
    Box(
        modifier = modifier
            .size(size)
            .clip(backgroundShape)
            .background(backgroundColor)
            .clickable(
                indication = rememberRipple(bounded = true),
                interactionSource = remember { MutableInteractionSource() },
                enabled = enabled,
                onClick = onClick,
                onClickLabel = contentDescription,
                role = Role.Button
            ),
        contentAlignment = Alignment.Center
    ) {
        Icon(
            modifier = Modifier.size(iconSize),
            painter = painter,
            contentDescription = contentDescription,
            tint = tint
        )
    }
}

@Preview(backgroundColor = 0xff_ff_00_ff, showBackground = true, widthDp = 100, heightDp = 100)
@Composable
fun Preview() {
    Theme {
        Box(contentAlignment = Alignment.Center) {
            GenericIconButton(
                painter = painterResource(id = R.drawable.ic_round_skip_next_24),
                onClick = { /*TODO*/ },
                backgroundColor = Color.White,
                backgroundShape = RectangleShape,
                tint = Color.Blue,
                size = DpSize(40.dp, 40.dp)
            )
        }
    }
}
