package com.moloco.sdk.xenoss.sdkdevkit.android.adrenderer.internal.ui

import androidx.compose.foundation.layout.BoxScope
import androidx.compose.runtime.Composable
import androidx.compose.runtime.LaunchedEffect
import androidx.compose.runtime.getValue
import androidx.compose.runtime.remember
import androidx.compose.runtime.rememberCoroutineScope
import androidx.compose.runtime.rememberUpdatedState
import androidx.compose.runtime.snapshotFlow
import androidx.lifecycle.compose.collectAsStateWithLifecycle
import com.moloco.sdk.xenoss.sdkdevkit.android.adrenderer.internal.countdownSecondsStateFlow
import com.moloco.sdk.xenoss.sdkdevkit.android.adrenderer.internal.vast.render.ValueWrapper
import com.moloco.sdk.xenoss.sdkdevkit.android.core.services.CustomUserEventBuilderService
import kotlinx.coroutines.flow.filter

// TODO. Most of the parameters are mutually exclusive.
//  Consider extracting "initialSecondsLeft", "canClickAfterCountdown", "onCountdownFinished" into a sealed class
//  similar to AdViewModel.GoNextAction.
/**
 * Lifecycle aware ad countdown button; 4....3....2....1 -> "Action button appears"
 * Currently used strictly by MRAID when adCloseCountdownButton is available
 */
@Composable
internal fun BoxScope.LifecycleAwareAdCountdownButton(
    initialSecondsLeft: ValueWrapper<UInt>,
    visible: Boolean,
    canClickAfterCountdown: Boolean,
    onCountdownFinished: () -> Unit,
    onClick: () -> Unit,
    onButtonRendered: (CustomUserEventBuilderService.UserInteraction.Button) -> Unit,
    basedOnAdCountdownButton: AdCountdownButton,
    enableCountDownTimer: Boolean
) {
    val scope = rememberCoroutineScope()

    val secondsLeft by remember(initialSecondsLeft) {
        countdownSecondsStateFlow(initialSecondsLeft.value, scope)
    }.collectAsStateWithLifecycle()

    val currentOnCountdownFinished by rememberUpdatedState(onCountdownFinished)

    LaunchedEffect(Unit) {
        snapshotFlow { secondsLeft }
            .filter { it == 0u }
            .collect { currentOnCountdownFinished() }
    }

    basedOnAdCountdownButton(
        canClickAfterCountdown,
        visible,
        onClick,
        onButtonRendered,
        enableCountDownTimer,
        initialSecondsLeft.value,
        secondsLeft
    )
}
