package com.moloco.sdk.xenoss.sdkdevkit.android.adrenderer.internal.vast.render.ad

import com.moloco.sdk.xenoss.sdkdevkit.android.adrenderer.internal.vast.VastTracker
import com.moloco.sdk.xenoss.sdkdevkit.android.adrenderer.internal.vast.model.VastError

internal class AdVastTracker(
    private var impressions: List<String>?,
    private var close: List<String>?,
    private val errors: List<String>?,
    private val vastTracker: VastTracker = VastTracker()
) {

    fun trackImpression(): Boolean = impressions?.let {
        vastTracker.track(it)
        impressions = null
        true
    } ?: false

    fun trackClose() {
        close?.let {
            vastTracker.track(it)
            close = null
        }
    }

    fun trackError(error: VastError? = null) {
        errors?.let { vastTracker.track(it, error) }
    }
}
