package com.moloco.sdk.xenoss.sdkdevkit.android.adrenderer.internal.vast.render.ad

import android.content.Context
import com.moloco.sdk.xenoss.sdkdevkit.android.adrenderer.internal.ExternalLinkHandler
import com.moloco.sdk.xenoss.sdkdevkit.android.adrenderer.internal.vast.render.Ad
import com.moloco.sdk.xenoss.sdkdevkit.android.adrenderer.internal.vast.render.companion.CompanionControllerImpl
import com.moloco.sdk.xenoss.sdkdevkit.android.adrenderer.internal.vast.render.dec.DECControllerImpl
import com.moloco.sdk.xenoss.sdkdevkit.android.adrenderer.internal.vast.render.linear.LinearControllerImpl
import com.moloco.sdk.xenoss.sdkdevkit.android.core.services.CustomUserEventBuilderService

internal fun Ad.toPlaylist(
    externalLinkHandler: ExternalLinkHandler,
    context: Context,
    customUserEventBuilderService: CustomUserEventBuilderService,
    mute: Boolean,
    overrideLinearGoNextActionEnabled: Boolean?,
    overrideLinearGoNextActionEnabledDelaySeconds: Int,
    companionGoNextActionDelaySeconds: Int,
    decGoNextActionDelaySeconds: Int,
    // Moloco feature: if user clicks skip button, open click through link without VAST click tracking.
    autoStoreOnSkip: Boolean,
    // Moloco feature: if video ends, open click through link without VAST click tracking.
    autoStoreOnComplete: Boolean
): List<PlaylistItem> = listOfNotNull(
    PlaylistItem.Linear(
        LinearControllerImpl(
            linear,
            positionMillis = 0,
            mute,
            overrideLinearGoNextActionEnabled,
            overrideLinearGoNextActionEnabledDelaySeconds,
            autoStoreOnSkip,
            autoStoreOnComplete,
            context = context,
            customUserEventBuilderService,
            externalLinkHandler
        )
    ),
    companion?.let {
        PlaylistItem.Companion(
            CompanionControllerImpl(
                it,
                companionGoNextActionDelaySeconds.coerceAtLeast(0).toUInt(),
                context,
                customUserEventBuilderService,
                externalLinkHandler
            )
        )
    },
    dec?.let {
        PlaylistItem.DEC(
            DECControllerImpl(
                it,
                linear.icon,
                decGoNextActionDelaySeconds.coerceAtLeast(0).toUInt(),
                context,
                customUserEventBuilderService,
                externalLinkHandler
            )
        )
    }
)
