package com.moloco.sdk.xenoss.sdkdevkit.android.adrenderer.internal.vast.render.companion

import com.moloco.sdk.xenoss.sdkdevkit.android.adrenderer.Destroyable
import com.moloco.sdk.xenoss.sdkdevkit.android.adrenderer.internal.errors.MolocoAdSubErrorType
import com.moloco.sdk.xenoss.sdkdevkit.android.adrenderer.internal.errors.VastAdShowError
import com.moloco.sdk.xenoss.sdkdevkit.android.adrenderer.internal.ui.ButtonRecorder
import com.moloco.sdk.xenoss.sdkdevkit.android.adrenderer.internal.vast.render.AdPartClickThrough
import com.moloco.sdk.xenoss.sdkdevkit.android.adrenderer.internal.vast.render.PreparedVastResource
import com.moloco.sdk.xenoss.sdkdevkit.android.core.services.CustomUserEventBuilderService.UserInteraction.Position
import kotlinx.coroutines.flow.Flow
import kotlinx.coroutines.flow.StateFlow

internal interface CompanionController : CompanionViewModel, Destroyable {
    val event: Flow<CompanionControllerEvent>
}

internal sealed class CompanionControllerEvent {
    object DisplayStarted : CompanionControllerEvent()
    data class Error(val error: MolocoAdSubErrorType) : CompanionControllerEvent()
    object ClickThrough : CompanionControllerEvent()
}

// TODO. Definitely rename to something like state/interactor whatever.
// It's the interface for user interactions.
interface CompanionViewModel : CompanionGoNextAction, AdPartClickThrough, ButtonRecorder {
    val resource: StateFlow<PreparedVastResource?>

    fun onError(error: MolocoAdSubErrorType)
    fun onLastClickPosition(position: Position)
    fun onDisplayStarted()
}
