package com.moloco.sdk.xenoss.sdkdevkit.android.adrenderer.internal.vast.render.companion

import com.moloco.sdk.xenoss.sdkdevkit.android.adrenderer.internal.ResettableCountdownSecondsStateFlow
import com.moloco.sdk.xenoss.sdkdevkit.android.adrenderer.internal.vast.render.GoNextAction
import kotlinx.coroutines.CoroutineScope
import kotlinx.coroutines.flow.SharingStarted
import kotlinx.coroutines.flow.StateFlow
import kotlinx.coroutines.flow.map
import kotlinx.coroutines.flow.stateIn

interface CompanionGoNextAction : GoNextAction {

    /**
     * Contract is reset "go next" action to the initial value.
     *
     */
    fun reset()
}

internal fun CompanionGoNextAction(
    countdownSeconds: UInt,
    scope: CoroutineScope
): CompanionGoNextAction = CompanionGoNextActionImpl(
    countdownSeconds,
    scope
)

private class CompanionGoNextActionImpl(
    private val countdownSeconds: UInt,
    scope: CoroutineScope
) : CompanionGoNextAction {

    private val resettableCountdownSecondsStateFlow = ResettableCountdownSecondsStateFlow(
        countdownSeconds,
        scope
    )

    override fun reset() {
        resettableCountdownSecondsStateFlow.resetTo(countdownSeconds)
    }

    override val goNextAction: StateFlow<GoNextAction.State> =
        resettableCountdownSecondsStateFlow.countdownSecondsStateFlow
            .map {
                it.toGoNextActionState()
            }.stateIn(
                scope,
                SharingStarted.WhileSubscribed(),
                countdownSeconds.toGoNextActionState()
            )
}

private fun UInt.toGoNextActionState() = if (this == 0u) {
    GoNextAction.State.Available
} else {
    GoNextAction.State.Countdown(this)
}
