package com.moloco.sdk.xenoss.sdkdevkit.android.adrenderer.internal.vast.render.companion

import com.moloco.sdk.xenoss.sdkdevkit.android.adrenderer.internal.ui.ButtonTracker
import com.moloco.sdk.xenoss.sdkdevkit.android.adrenderer.internal.vast.VastTracker
import com.moloco.sdk.xenoss.sdkdevkit.android.core.services.CustomUserEventBuilderService
import com.moloco.sdk.xenoss.sdkdevkit.android.core.services.CustomUserEventBuilderService.UserInteraction.Position

class CompanionVastTracker(
    private val customUserEventBuilderService: CustomUserEventBuilderService,
    private var clickTracking: List<String>?,
    private var creativeViewTracking: List<String>?,
    private val buttonTracker: ButtonTracker = ButtonTracker(),
    private val vastTracker: VastTracker = VastTracker()
) {

    fun trackButtonRender(button: CustomUserEventBuilderService.UserInteraction.Button) {
        buttonTracker.onButtonRendered(button)
    }

    fun trackButtonUnRender(
        buttonType: CustomUserEventBuilderService.UserInteraction.Button.ButtonType
    ) {
        buttonTracker.onButtonUnRendered(buttonType)
    }

    fun trackClick(lastClickPosition: Position) {
        clickTracking?.let {
            vastTracker.trackClick(
                urls = it,
                customUserEventBuilderService = customUserEventBuilderService,
                renderedButtons = buttonTracker.renderedButtons(),
                lastClickPosition = lastClickPosition
            )
            clickTracking = null
        }
    }

    fun trackCreativeView() {
        creativeViewTracking?.let {
            vastTracker.track(it)
            creativeViewTracking = null
        }
    }
}
