package com.moloco.sdk.xenoss.sdkdevkit.android.adrenderer.internal.vast.render.compose

import androidx.compose.foundation.layout.Box
import androidx.compose.runtime.Composable
import androidx.compose.runtime.LaunchedEffect
import androidx.compose.runtime.collectAsState
import androidx.compose.runtime.getValue
import androidx.compose.ui.Modifier
import androidx.compose.ui.input.pointer.pointerInput
import androidx.compose.ui.platform.testTag
import com.moloco.sdk.internal.scheduling.DispatcherProvider
import com.moloco.sdk.xenoss.sdkdevkit.android.adrenderer.internal.ui.utils.ScreenUtils.toPosition
import com.moloco.sdk.xenoss.sdkdevkit.android.adrenderer.internal.vast.render.compose.touch.detectTapUnconsumed
import com.moloco.sdk.xenoss.sdkdevkit.android.adrenderer.internal.vast.render.dec.DECViewModel
import kotlinx.coroutines.withContext

@Composable
internal fun DEC(
    viewModel: DECViewModel,
    overrideDECOnClick: (() -> Unit)?,
    VastIcon: VastIcon?,
    modifier: Modifier = Modifier
) {
    LaunchedEffect(Unit) {
        withContext(DispatcherProvider().main) {
            viewModel.onDisplayStarted()
        }
    }

    Box(modifier = modifier) {
        com.moloco.sdk.xenoss.sdkdevkit.android.adrenderer.internal.ui.DEC(
            modifier = Modifier
                .testTag("DECContainer")
                .pointerInput(Unit) {
                detectTapUnconsumed { firstTapTouch, _ ->
                    overrideDECOnClick?.invoke()
                        ?: viewModel.onClickThrough(firstTapTouch.toPosition())
                }
            },
            appIconUri = viewModel.appIconUri,
            appName = viewModel.appName,
            cta = viewModel.ctaText,
            onClick = { /* no-op */ }
        )

        VastIcon?.let {
            val vastPrivacyIcon by viewModel.vastPrivacyIcon.collectAsState()
            it(
                vastPrivacyIcon,
                viewModel::onVastPrivacyIconDisplayed,
                viewModel::onVastPrivacyIconClick
            )
        }
    }
}
