package com.moloco.sdk.xenoss.sdkdevkit.android.adrenderer.internal.webview

import android.content.Context
import android.view.View
import android.view.ViewGroup
import android.view.ViewGroup.LayoutParams.MATCH_PARENT
import android.webkit.WebView
import android.widget.FrameLayout

/**
 * Context below: Wraps our banner WebView
 */
internal class BannerWebViewWrapper {

    /**
     * Adds the `WebView` as a child of a container wrapper (`FrameLayout`) to address layout issues.
     *
     * **Background:**
     * Adding a `WebView` directly without a wrapper can result in `window.innerHeight` being
     * temporarily set to `0` during HTML content layout passes. This behavior can cause
     * unexpected bugs in JavaScript-based creatives, particularly those relying on `window.innerHeight`
     * for layout or rendering logic.
     *
     * **Real-World Example:**
     * - In the "King Dungeon" MRAID game, when MRAID visibility is set to `true`, the
     *   JavaScript WebGL framebuffer code breaks due to transient layout passes where
     *   `window.innerHeight == 0`.
     *
     * **Solution:**
     * Wrapping the `WebView` in a container like `FrameLayout` ensures that
     * `window.innerHeight` values remain stable during layout passes, avoiding
     * transient `0` values and associated rendering issues.
     */
    internal fun wrapWebView(context:Context, webView: WebView): FrameLayout {
        // Force remove webView ASAP to avoid
        // "java.lang.IllegalStateException: The specified child already has a parent." exceptions.
        (webView.parent as? ViewGroup)?.removeView(webView)

        with(webView) {
            setBackgroundColor(android.graphics.Color.TRANSPARENT)
            visibility = View.VISIBLE
        }

        return FrameLayout(context).apply {
            addView(
                webView,
                ViewGroup.LayoutParams(
                    MATCH_PARENT,
                    MATCH_PARENT
                )
            )
        }
    }
}
