package com.moloco.sdk.xenoss.sdkdevkit.android.core.services

/**
 * Config service that tracks whether custom event reporting (Project telepathy) is enabled
 * or not. If the config is enabled, custom events should be reported as part of the tracker
 */
interface CustomUserEventConfigService {
    /**
     * Sets whether the reporting is enabled
     */
    fun configure(
        eventCollectionEnabled: Boolean,
        userTrackingEnabled: Boolean,
        appForegroundUrl: String,
        appBackgroundUrl: String,
    )

    /**
     * @return True if the custom user event reporting is enabled (Project Telepathy)
     */
    fun isCustomUserEventReportingEnabled(): Boolean

    /**
     * @return True if the custom user event can include user tracker id
     */
    fun isUserTrackingEnabled(): Boolean

    /**
     * @return The URL that is parsed from the config service to publish app fg events to
     */
    fun applicationForegroundUrl(): String

    /**
     * @return The URL that is parsed from the config service to publish app bg events to
     */
    fun applicationBackgroundUrl(): String
}
