/*
 * Decompiled with CFR 0.152.
 */
package org.bson;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.bson.BSONDeserializer;
import org.bson.BSONDeserializer$;
import org.bson.BSONException;
import org.bson.BasicBSONDecoder;
import org.bson.io.BSONInput;
import org.bson.io.Bits;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.collection.Seq;
import scala.reflect.ClassManifest;
import scala.reflect.Manifest$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public abstract class BSONDeserializer$class {
    public static void reset(BSONDeserializer $this) {
        $this.callback().reset();
        ((BasicBSONDecoder)$this)._in = null;
        ((BasicBSONDecoder)$this)._callback = null;
    }

    public static Object get(BSONDeserializer $this) {
        return $this.callback().get();
    }

    /*
     * WARNING - void declaration
     */
    public static int decode(BSONDeserializer $this, boolean first) {
        void var2_2;
        int len$1 = ((BasicBSONDecoder)$this)._in.readInt();
        if (first) {
            ((BasicBSONDecoder)$this)._in.setMax(len$1);
        }
        $this.log().trace((Function0<String>)new Serializable($this){
            public static final long serialVersionUID;

            static {
                long l = serialVersionUID = 0L;
            }

            public final String apply() {
                return "Decoding, length: %d";
            }
        }, BoxesRunTime.boxToInteger((int)len$1), (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[0]));
        ((BasicBSONDecoder)$this)._callback.objectStart();
        while ($this.decodeElement()) {
            $this.log().trace((Function0<String>)new Serializable($this){
                public static final long serialVersionUID;

                static {
                    long l = serialVersionUID = 0L;
                }

                public final String apply() {
                    return "Decode Loop";
                }
            });
        }
        ((BasicBSONDecoder)$this)._callback.objectDone();
        Predef$.MODULE$.require(((BasicBSONDecoder)$this)._in.numRead() == len$1 && first, (Function0)new Serializable($this, len$1){
            public static final long serialVersionUID;
            private final BSONDeserializer $outer;
            private final int len$1;

            static {
                long l = serialVersionUID = 0L;
            }

            public final String apply() {
                return Predef$.MODULE$.augmentString("Bad Data? Post-Read Lengths don't match up. Expected: %d, Got: %d").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.len$1), BoxesRunTime.boxToInteger((int)((BasicBSONDecoder)this.$outer)._in.numRead())}));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.len$1 = n;
            }
        });
        return (int)var2_2;
    }

    public static Object decodeAndFetch(BSONDeserializer $this, InputStream in) {
        $this.log().trace((Function0<String>)new Serializable($this){
            public static final long serialVersionUID;

            static {
                long l = serialVersionUID = 0L;
            }

            public final String apply() {
                return "DecodeAndFetch.";
            }
        });
        $this.log().trace((Function0<String>)new Serializable($this){
            public static final long serialVersionUID;

            static {
                long l = serialVersionUID = 0L;
            }

            public final String apply() {
                return "Reset.";
            }
        });
        Integer exceptionResult1 = null;
        try {
            exceptionResult1 = BoxesRunTime.boxToInteger((int)$this.decode(in, $this.callback()));
        }
        catch (Throwable throwable) {
            $this.log().error(throwable, (Function0<String>)new Serializable($this){
                public static final long serialVersionUID;

                static {
                    long l = serialVersionUID = 0L;
                }

                public final String apply() {
                    return "Failed to decode message with callback.";
                }
            });
            exceptionResult1 = BoxedUnit.UNIT;
        }
        $this.log().trace((Function0<String>)new Serializable($this){
            public static final long serialVersionUID;

            static {
                long l = serialVersionUID = 0L;
            }

            public final String apply() {
                return "Decoded, getting.";
            }
        });
        Object obj = $this.get();
        $this.log().trace((Function0<String>)new Serializable($this){
            public static final long serialVersionUID;

            static {
                long l = serialVersionUID = 0L;
            }

            public final String apply() {
                return "Decoded, got %s.";
            }
        }, obj, (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[0]));
        return $this.get();
    }

    public static int decode(BSONDeserializer $this, InputStream in, BSONDeserializer.Callback callback) {
        int exceptionResult2 = 0;
        try {
            exceptionResult2 = $this._decode(new BSONInput(in), callback);
            return exceptionResult2;
        }
        catch (Throwable throwable) {
            $this.log().error(throwable, (Function0<String>)new Serializable($this){
                public static final long serialVersionUID;

                static {
                    long l = serialVersionUID = 0L;
                }

                public final String apply() {
                    return "Unexpected exception in decode";
                }
            });
            throw throwable;
        }
        catch (IOException iOException) {
            $this.log().error(iOException, (Function0<String>)new Serializable($this){
                public static final long serialVersionUID;

                static {
                    long l = serialVersionUID = 0L;
                }

                public final String apply() {
                    return "OMG! PONIES!";
                }
            });
            throw new BSONException("Failed to decode input data.", (Throwable)iOException);
        }
    }

    public static int decode(BSONDeserializer $this, byte[] b, BSONDeserializer.Callback callback) {
        int exceptionResult3 = 0;
        try {
            exceptionResult3 = $this._decode(new BSONInput((InputStream)new ByteArrayInputStream(b)), callback);
            return exceptionResult3;
        }
        catch (Throwable throwable) {
            $this.log().error(throwable, (Function0<String>)new Serializable($this){
                public static final long serialVersionUID;

                static {
                    long l = serialVersionUID = 0L;
                }

                public final String apply() {
                    return "Unexpected exception in decode";
                }
            });
            throw throwable;
        }
        catch (IOException iOException) {
            throw new BSONException("Failed to decode input data.", (Throwable)iOException);
        }
    }

    public static boolean decode$default$1(BSONDeserializer $this) {
        return true;
    }

    public static int _decode(BSONDeserializer $this, BSONInput in, BSONDeserializer.Callback callback) {
        Predef$.MODULE$.require(in.numRead() == 0, (Function0)new Serializable($this){
            public static final long serialVersionUID;

            static {
                long l = serialVersionUID = 0L;
            }

            public final String apply() {
                return "Invalid Read Bytes State on Input Object.";
            }
        });
        int exceptionResult4 = 0;
        try {
            if (((BasicBSONDecoder)$this)._in == null) {
                ((BasicBSONDecoder)$this)._in = in;
                if (((BasicBSONDecoder)$this)._callback == null) {
                    ((BasicBSONDecoder)$this)._callback = callback;
                    exceptionResult4 = $this.decode($this.decode$default$1());
                    return exceptionResult4;
                }
                throw new IllegalStateException("_callback already defined; bad state.");
            }
            throw new IllegalStateException("_in already defined; bad state.");
        }
        finally {
            ((BasicBSONDecoder)$this)._in = null;
            ((BasicBSONDecoder)$this)._callback = null;
        }
    }

    public static boolean decodeElement(BSONDeserializer $this) {
        boolean bl;
        byte t = ((BasicBSONDecoder)$this)._in.read();
        if (t == 0) {
            $this.log().trace((Function0<String>)new Serializable($this){
                public static final long serialVersionUID;

                static {
                    long l = serialVersionUID = 0L;
                }

                public final String apply() {
                    return "End of Object. ";
                }
            });
            bl = false;
        } else {
            String name = ((BasicBSONDecoder)$this)._in.readCStr();
            $this.log().trace((Function0<String>)new Serializable($this){
                public static final long serialVersionUID;

                static {
                    long l = serialVersionUID = 0L;
                }

                public final String apply() {
                    return "Element Decoding with Name '%s', Type '%s'";
                }
            }, name, (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToByte((byte)t)}));
            $this.decodeField(name, t);
            bl = true;
        }
        return bl;
    }

    public static void decodeField(BSONDeserializer $this, String name, byte t) {
        ((Function1)$this._getHandle().apply((Object)BoxesRunTime.boxToByte((byte)t))).apply((Object)name);
    }

    public static byte[] _rawObject(BSONDeserializer $this) {
        byte[] l = (byte[])Array$.MODULE$.ofDim(4, (ClassManifest)Manifest$.MODULE$.Byte());
        ((BasicBSONDecoder)$this)._in.fill(l);
        int len = Bits.readInt((byte[])l);
        byte[] b = (byte[])Array$.MODULE$.ofDim(len - 4, (ClassManifest)Manifest$.MODULE$.Byte());
        ((BasicBSONDecoder)$this)._in.fill(b);
        byte[] n = (byte[])Array$.MODULE$.concat((Seq)Predef$.MODULE$.wrapRefArray((Object[])new byte[][]{l, b}), (ClassManifest)Manifest$.MODULE$.Byte());
        return n;
    }

    public static void $init$(BSONDeserializer $this) {
        $this.org$bson$BSONDeserializer$_setter_$_getHandle_$eq(new BSONDeserializer$.anonfun.1($this));
    }
}

