/*
 * Decompiled with CFR 0.152.
 */
package org.bson;

import java.util.regex.Pattern;
import org.bson.BSON;
import org.bson.BSONSerializer;
import org.bson.BSONSerializer$;
import org.bson.BasicBSONEncoder;
import org.bson.collection.BSONList;
import org.bson.io.BasicOutputBuffer;
import org.bson.io.OutputBuffer;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.IterableLike;
import scala.collection.Map;
import scala.collection.Seq;
import scala.reflect.ClassManifest;
import scala.reflect.Manifest$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Null$;
import scala.runtime.ScalaRunTime$;
import scala.util.matching.Regex;

public abstract class BSONSerializer$class {
    public static void encode(BSONSerializer $this, Map obj, OutputBuffer out) {
        ((BasicBSONEncoder)$this).set(out);
        $this.putObject((Map<String, Object>)obj);
        ((BasicBSONEncoder)$this).done();
    }

    public static byte[] encode(BSONSerializer $this, Map obj) {
        BasicOutputBuffer buf = new BasicOutputBuffer();
        $this.encode((Map<String, Object>)obj, (OutputBuffer)buf);
        return buf.toByteArray();
    }

    public static int encodeObject(BSONSerializer $this, byte[] o) {
        int start = ((BasicBSONEncoder)$this)._buf.getPosition();
        ((BasicBSONEncoder)$this)._buf.write(o);
        return ((BasicBSONEncoder)$this)._buf.getPosition() - start;
    }

    public static int putObject(BSONSerializer $this, Map o) {
        return $this.putObject((Option<String>)None$.MODULE$, (Map<String, Object>)o);
    }

    public static int putObject(BSONSerializer $this, String name, Map o) {
        return $this.putObject((Option<String>)new Some((Object)name), (Map<String, Object>)o);
    }

    public static int putObject(BSONSerializer $this, Option name, Map o) {
        Predef$.MODULE$.require(o != null, (Function0)new Serializable($this){
            public static final long serialVersionUID;

            static {
                long l = serialVersionUID = 0L;
            }

            public final String apply() {
                return "Cannot serialize null objects.";
            }
        });
        $this.log().debug((Function0<String>)new Serializable($this){
            public static final long serialVersionUID;

            static {
                long l = serialVersionUID = 0L;
            }

            public final String apply() {
                return "PutObject {name: '%s', value: '%s'";
            }
        }, name.getOrElse((Function0)new Serializable($this){
            public static final long serialVersionUID;

            static {
                long l = serialVersionUID = 0L;
            }

            public final String apply() {
                return "null";
            }
        }), (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{o}));
        int start = ((BasicBSONEncoder)$this)._buf.getPosition();
        Object object = $this.handleSpecialObjects((String)name.getOrElse((Function0)new Serializable($this){
            public static final long serialVersionUID;

            static {
                long l = serialVersionUID = 0L;
            }

            public final Null$ apply() {
                return null;
            }
        }), (Map<String, Object>)o) ? BoxesRunTime.boxToInteger((int)(((BasicBSONEncoder)$this)._buf.getPosition() - start)) : BoxedUnit.UNIT;
        byte _type$1 = o instanceof BSONList ? (byte)4 : 3;
        name.foreach((Function1)new Serializable($this, _type$1){
            public static final long serialVersionUID;
            private final BSONSerializer $outer;
            private final byte _type$1;

            static {
                long l = serialVersionUID = 0L;
            }

            public final void apply(String string) {
                ((BasicBSONEncoder)this.$outer)._put(this._type$1, string);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this._type$1 = by;
            }
        });
        boolean rewriteID = _type$1 == 3 && name.isEmpty();
        int sizePos = ((BasicBSONEncoder)$this)._buf.getPosition();
        ((BasicBSONEncoder)$this)._buf.writeInt(0);
        ((IterableLike)o.filter((Function1)new Serializable($this){
            public static final long serialVersionUID;

            static {
                long l = serialVersionUID = 0L;
            }

            public final boolean apply(Tuple2<String, Object> tuple2) {
                Tuple2<String, Object> tuple22 = tuple2;
                return tuple22 != null;
            }
        })).foreach((Function1)new Serializable($this){
            public static final long serialVersionUID;
            private final BSONSerializer $outer;

            static {
                long l = serialVersionUID = 0L;
            }

            public final void apply(Tuple2<String, Object> tuple2) {
                Tuple2<String, Object> tuple22 = tuple2;
                if (tuple22 != null) {
                    String string = (String)tuple22._1();
                    Object object = tuple22._2();
                    String k = string;
                    Object v = object;
                    this.$outer.log().trace((Function0<String>)new Serializable(this){
                        public static final long serialVersionUID;

                        static {
                            long l = serialVersionUID = 0L;
                        }

                        public final String apply() {
                            return "Key: %s, Value: %s";
                        }
                    }, k, (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{v}));
                    this.$outer._putObjectField(k, v);
                    return;
                }
                throw new MatchError(tuple22);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        ((BasicBSONEncoder)$this)._buf.write(0);
        int sz = ((BasicBSONEncoder)$this)._buf.getPosition() - sizePos;
        $this.log().debug((Function0<String>)new Serializable($this){
            public static final long serialVersionUID;

            static {
                long l = serialVersionUID = 0L;
            }

            public final String apply() {
                return "Size of Document: %d, %d";
            }
        }, BoxesRunTime.boxToInteger((int)sizePos), (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)sz)}));
        ((BasicBSONEncoder)$this)._buf.writeInt(sizePos, sz);
        return ((BasicBSONEncoder)$this)._buf.getPosition() - start;
    }

    public static void _putObjectField(BSONSerializer $this, String name, Object value) {
        Object object;
        $this.log().trace((Function0<String>)new Serializable($this){
            public static final long serialVersionUID;

            static {
                long l = serialVersionUID = 0L;
            }

            public final String apply() {
                return "\t Put Field '%s' - '%s'";
            }
        }, name, (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{value}));
        Object object2 = object = value;
        String string = "$where";
        if (!(object2 != null ? !object2.equals(string) : string != null)) {
            $this.log().trace((Function0<String>)new Serializable($this){
                public static final long serialVersionUID;

                static {
                    long l = serialVersionUID = 0L;
                }

                public final String apply() {
                    return "Where clause.";
                }
            });
            ((BasicBSONEncoder)$this)._put((byte)13, name);
            ((BasicBSONEncoder)$this)._putValueString(value.toString());
        } else {
            $this.log().trace((Function0<String>)new Serializable($this){
                public static final long serialVersionUID;

                static {
                    long l = serialVersionUID = 0L;
                }

                public final String apply() {
                    return "Applying Encoding Hooks";
                }
            });
            ((Function1)$this._putHandle().apply(BSON.applyEncodingHooks((Object)value))).apply((Object)name);
        }
    }

    public static void putArray(BSONSerializer $this, String name, Object arr$2) {
        ((BasicBSONEncoder)$this)._put((byte)4, name);
        int sizePos = ((BasicBSONEncoder)$this)._buf.getPosition();
        ((BasicBSONEncoder)$this)._buf.writeInt(0);
        Predef$.MODULE$.intWrapper(0).until(ScalaRunTime$.MODULE$.array_length(arr$2)).foreach$mVc$sp((Function1)new Serializable($this, arr$2){
            public static final long serialVersionUID;
            private final BSONSerializer $outer;
            private final Object arr$2;

            static {
                long l = serialVersionUID = 0L;
            }

            public final void apply(int i) {
                this.apply$mcVI$sp(i);
            }

            public void apply$mcVI$sp(int v1) {
                this.$outer._putObjectField(((Object)BoxesRunTime.boxToInteger((int)v1)).toString(), ScalaRunTime$.MODULE$.array_apply(this.arr$2, v1));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.arr$2 = object;
            }
        });
        ((BasicBSONEncoder)$this)._buf.write(0);
        int sz = ((BasicBSONEncoder)$this)._buf.getPosition() - sizePos;
        $this.log().debug((Function0<String>)new Serializable($this){
            public static final long serialVersionUID;

            static {
                long l = serialVersionUID = 0L;
            }

            public final String apply() {
                return "Size of Array: %d";
            }
        }, BoxesRunTime.boxToInteger((int)sz), (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[0]));
        ((BasicBSONEncoder)$this)._buf.writeInt(sizePos, sz);
    }

    public static void putList(BSONSerializer $this, String name, Seq lst$2) {
        ((BasicBSONEncoder)$this)._put((byte)4, name);
        int sizePos = ((BasicBSONEncoder)$this)._buf.getPosition();
        ((BasicBSONEncoder)$this)._buf.writeInt(0);
        Predef$.MODULE$.intWrapper(0).until(lst$2.length()).foreach$mVc$sp((Function1)new Serializable($this, lst$2){
            public static final long serialVersionUID;
            private final BSONSerializer $outer;
            private final Seq lst$2;

            static {
                long l = serialVersionUID = 0L;
            }

            public final void apply(int i) {
                this.apply$mcVI$sp(i);
            }

            public void apply$mcVI$sp(int v1) {
                this.$outer._putObjectField(((Object)BoxesRunTime.boxToInteger((int)v1)).toString(), this.lst$2.apply(v1));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.lst$2 = seq;
            }
        });
        ((BasicBSONEncoder)$this)._buf.write(0);
        int sz = ((BasicBSONEncoder)$this)._buf.getPosition() - sizePos;
        $this.log().debug((Function0<String>)new Serializable($this){
            public static final long serialVersionUID;

            static {
                long l = serialVersionUID = 0L;
            }

            public final String apply() {
                return "Size of List: %d";
            }
        }, BoxesRunTime.boxToInteger((int)sz), (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[0]));
        ((BasicBSONEncoder)$this)._buf.writeInt(sizePos, sz);
    }

    public static void putMap(BSONSerializer $this, String name, Map m) {
        ((BasicBSONEncoder)$this)._put((byte)3, name);
        int sizePos = ((BasicBSONEncoder)$this)._buf.getPosition();
        ((BasicBSONEncoder)$this)._buf.writeInt(0);
        ((IterableLike)m.filter((Function1)new Serializable($this){
            public static final long serialVersionUID;

            static {
                long l = serialVersionUID = 0L;
            }

            public final boolean apply(Tuple2<Object, Object> tuple2) {
                Tuple2<Object, Object> tuple22 = tuple2;
                return tuple22 != null;
            }
        })).foreach((Function1)new Serializable($this){
            public static final long serialVersionUID;
            private final BSONSerializer $outer;

            static {
                long l = serialVersionUID = 0L;
            }

            public final void apply(Tuple2<Object, Object> tuple2) {
                Tuple2<Object, Object> tuple22 = tuple2;
                if (tuple22 != null) {
                    Object object = tuple22._1();
                    Object object2 = tuple22._2();
                    Object k = object;
                    Object v = object2;
                    this.$outer.log().trace((Function0<String>)new Serializable(this){
                        public static final long serialVersionUID;

                        static {
                            long l = serialVersionUID = 0L;
                        }

                        public final String apply() {
                            return "Key: %s, Value: %s";
                        }
                    }, k, (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{v}));
                    this.$outer._putObjectField(k.toString(), v);
                    return;
                }
                throw new MatchError(tuple22);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        ((BasicBSONEncoder)$this)._buf.write(0);
        int sz = ((BasicBSONEncoder)$this)._buf.getPosition() - sizePos;
        $this.log().debug((Function0<String>)new Serializable($this){
            public static final long serialVersionUID;

            static {
                long l = serialVersionUID = 0L;
            }

            public final String apply() {
                return "Size of Document: %d";
            }
        }, BoxesRunTime.boxToInteger((int)sz), (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[0]));
        ((BasicBSONEncoder)$this)._buf.writeInt(sizePos, sz);
    }

    public static void putPattern(BSONSerializer $this, String name, Regex r) {
        $this.putPattern(name, r.pattern());
    }

    public static void putPattern(BSONSerializer $this, String name, Pattern p) {
        ((BasicBSONEncoder)$this)._put((byte)11, name);
        ((BasicBSONEncoder)$this)._put(p.pattern());
        ((BasicBSONEncoder)$this)._put(BSON.regexFlags((int)p.flags()));
    }

    public static void putIterable(BSONSerializer $this, String name, Iterable i) {
        $this.putArray(name, i.toArray((ClassManifest)Manifest$.MODULE$.Any()));
    }

    public static boolean putSpecial(BSONSerializer $this, String name, Map o) {
        return false;
    }

    public static boolean handleSpecialObjects(BSONSerializer $this, String name, Map o) {
        return false;
    }

    public static int size(BSONSerializer $this) {
        return ((BasicBSONEncoder)$this)._buf.size();
    }

    public static void seek(BSONSerializer $this, int bytes) {
        int pos = ((BasicBSONEncoder)$this)._buf.getPosition() + bytes;
        $this.log().debug((Function0<String>)new Serializable($this){
            public static final long serialVersionUID;

            static {
                long l = serialVersionUID = 0L;
            }

            public final String apply() {
                return "Seeking to %d";
            }
        }, BoxesRunTime.boxToInteger((int)pos), (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[0]));
    }

    public static boolean active(BSONSerializer $this) {
        return ((BasicBSONEncoder)$this)._buf == null;
    }

    public static void $init$(BSONSerializer $this) {
        $this.org$bson$BSONSerializer$_setter_$_putHandle_$eq(new BSONSerializer$.anonfun.1($this));
    }
}

