/*
 * Decompiled with CFR 0.152.
 */
package org.bson;

import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.regex.Pattern;
import org.bson.BSON;
import org.bson.BSONException;
import org.bson.BSONObject;
import org.bson.BasicBSONObject;
import org.bson.LazyBSONCallback;
import org.bson.io.Bits;
import org.bson.types.BSONTimestamp;
import org.bson.types.Binary;
import org.bson.types.Code;
import org.bson.types.CodeWScope;
import org.bson.types.MaxKey;
import org.bson.types.MinKey;
import org.bson.types.ObjectId;
import org.bson.types.Symbol;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LazyBSONObject
implements BSONObject {
    static final int FIRST_ELMT_OFFSET = 4;
    private byte[] _data;
    private int _start;
    private LazyBSONCallback _cbk;

    public LazyBSONObject(byte[] data, LazyBSONCallback cbk) {
        this(data, 0, cbk);
    }

    public LazyBSONObject(byte[] data, int offset, LazyBSONCallback cbk) {
        this._data = data;
        this._start = offset;
        this._cbk = cbk;
    }

    @Override
    public Object put(String key, Object v) {
        throw new UnsupportedOperationException("Object is read only");
    }

    @Override
    public void putAll(BSONObject o) {
        throw new UnsupportedOperationException("Object is read only");
    }

    @Override
    public void putAll(Map m) {
        throw new UnsupportedOperationException("Object is read only");
    }

    @Override
    public Object get(String key) {
        int offset = 4;
        boolean found = false;
        while (!this.isElementEmpty(offset)) {
            String name = this.getElementFieldName(offset);
            if (name.equals(key)) {
                found = true;
                break;
            }
            offset += this.getElementBSONSize(offset);
        }
        if (!found) {
            return null;
        }
        return this.getElementValue(offset);
    }

    @Override
    public Map toMap() {
        throw new UnsupportedOperationException("Not Supported");
    }

    @Override
    public Object removeField(String key) {
        throw new UnsupportedOperationException("Object is read only");
    }

    @Override
    @Deprecated
    public boolean containsKey(String s) {
        return this.containsField(s);
    }

    @Override
    public boolean containsField(String s) {
        return this.keySet().contains(s);
    }

    @Override
    public Set<String> keySet() {
        return new LazyBSONKeySet();
    }

    private boolean isElementEmpty(int elmtOff) {
        return this.getElementType(elmtOff) == 0;
    }

    public boolean isEmpty() {
        return this.isElementEmpty(4);
    }

    private int getBSONSize(int objOff) {
        return Bits.readInt(this._data, objOff);
    }

    public int getBSONSize() {
        return this.getBSONSize(this._start);
    }

    private String getElementFieldName(int elmtOff) {
        return this.readElementCStringValue(this._start + elmtOff + 1);
    }

    private int getElementFieldNameSize(int elmtOff) {
        int offset;
        int end = offset = this._start + elmtOff + 1;
        while (this._data[end] != 0) {
            ++end;
        }
        return end - offset + 1;
    }

    private byte getElementType(int elmtOff) {
        return this._data[this._start + elmtOff];
    }

    private int getElementBSONSize(int elmtOff) {
        int x = 0;
        byte type = this.getElementType(elmtOff);
        int fieldSize = this.getElementFieldNameSize(elmtOff);
        int valueOffset = this._start + elmtOff + 1 + fieldSize;
        switch (type) {
            case -1: 
            case 0: 
            case 6: 
            case 10: 
            case 127: {
                break;
            }
            case 8: {
                x = 1;
                break;
            }
            case 16: {
                x = 4;
                break;
            }
            case 1: 
            case 9: 
            case 17: 
            case 18: {
                x = 8;
                break;
            }
            case 7: {
                x = 12;
                break;
            }
            case 2: 
            case 13: 
            case 14: {
                x = Bits.readInt(this._data, valueOffset) + 4;
                break;
            }
            case 15: {
                x = this.getBSONSize(valueOffset);
                break;
            }
            case 12: {
                x = Bits.readInt(this._data, valueOffset) + 4 + 12;
                break;
            }
            case 3: 
            case 4: {
                x = this.getBSONSize(valueOffset);
                break;
            }
            case 5: {
                x = Bits.readInt(this._data, valueOffset) + 4 + 1;
                break;
            }
            case 11: {
                int end = valueOffset;
                while (this._data[end] != 0) {
                    ++end;
                }
                ++end;
                while (this._data[end] != 0) {
                    ++end;
                }
                x = ++end - valueOffset;
                break;
            }
            default: {
                throw new BSONException("Invalid type " + type + " for field " + this.getElementFieldName(elmtOff));
            }
        }
        return x + fieldSize + 1;
    }

    private String readElementStringValue(int valueOffset) {
        int size = Bits.readInt(this._data, valueOffset);
        return new String(this._data, valueOffset + 4, size);
    }

    private String readElementStringValueAscii(int valueOffset) {
        int size = Bits.readInt(this._data, valueOffset);
        char[] chars = new char[size];
        valueOffset += 4;
        for (int i = 0; i < size; ++i) {
            chars[i] = (char)this._data[valueOffset + i];
        }
        return new String(chars, 0, size);
    }

    private String readElementCStringValue(int valueOffset) {
        int end = valueOffset;
        while (this._data[end] != 0) {
            ++end;
        }
        int len = end - valueOffset;
        if (len == 3 && this._data[valueOffset] == 95 && this._data[valueOffset + 1] == 105 && this._data[valueOffset + 2] == 100) {
            return "_id";
        }
        return new String(this._data, valueOffset, len);
    }

    private String readElementCStringValueAscii(int valueOffset) {
        int end = valueOffset;
        while (this._data[end] != 0) {
            ++end;
        }
        int len = end - valueOffset;
        char[] chars = new char[len];
        for (int i = 0; i < len; ++i) {
            chars[i] = (char)this._data[valueOffset + i];
        }
        return new String(chars, 0, len);
    }

    private Object getElementValue(int elmtOff) {
        boolean x = false;
        byte type = this.getElementType(elmtOff);
        int fieldSize = this.getElementFieldNameSize(elmtOff);
        int valueOffset = this._start + elmtOff + 1 + fieldSize;
        switch (type) {
            case 0: 
            case 6: 
            case 10: {
                return null;
            }
            case 127: {
                return new MaxKey();
            }
            case -1: {
                return new MinKey();
            }
            case 8: {
                return this._data[valueOffset] != 0;
            }
            case 16: {
                return Bits.readInt(this._data, valueOffset);
            }
            case 17: {
                int inc = Bits.readInt(this._data, valueOffset);
                int time = Bits.readInt(this._data, valueOffset + 4);
                return new BSONTimestamp(time, inc);
            }
            case 9: {
                return new Date(Bits.readLong(this._data, valueOffset));
            }
            case 18: {
                return Bits.readLong(this._data, valueOffset);
            }
            case 1: {
                return Double.longBitsToDouble(Bits.readLong(this._data, valueOffset));
            }
            case 7: {
                return new ObjectId(Bits.readIntBE(this._data, valueOffset), Bits.readIntBE(this._data, valueOffset + 4), Bits.readIntBE(this._data, valueOffset + 8));
            }
            case 14: {
                return new Symbol(this.readElementStringValue(valueOffset));
            }
            case 13: {
                return new Code(this.readElementStringValue(valueOffset));
            }
            case 2: {
                return this.readElementStringValue(valueOffset);
            }
            case 15: {
                int size = Bits.readInt(this._data, valueOffset);
                int strsize = Bits.readInt(this._data, valueOffset + 4);
                String code = this.readElementStringValue(valueOffset + 4);
                BSONObject scope = (BSONObject)this._cbk.createObject(this._data, valueOffset + 4 + 4 + strsize);
                return new CodeWScope(code, scope);
            }
            case 12: {
                int csize = Bits.readInt(this._data, valueOffset);
                String ns = this.readElementCStringValue(valueOffset + 4);
                int oidOffset = valueOffset + csize + 4;
                ObjectId oid = new ObjectId(Bits.readIntBE(this._data, oidOffset), Bits.readIntBE(this._data, oidOffset + 4), Bits.readIntBE(this._data, oidOffset + 8));
                return new BasicBSONObject("$ns", ns).append("$id", oid);
            }
            case 3: {
                return this._cbk.createObject(this._data, valueOffset);
            }
            case 4: {
                return this._cbk.createObject(this._data, valueOffset);
            }
            case 5: {
                return this.readBinary(valueOffset);
            }
            case 11: {
                String pattern = this.readElementCStringValue(valueOffset);
                int end = valueOffset;
                while (this._data[end] != 0) {
                    ++end;
                }
                String flags = this.readElementCStringValue(++end);
                return Pattern.compile(pattern, BSON.regexFlags(flags));
            }
        }
        throw new BSONException("Invalid type " + type + " for field " + this.getElementFieldName(elmtOff));
    }

    protected Object readBinary(int valueOffset) {
        int totalLen = Bits.readInt(this._data, valueOffset);
        byte bType = this._data[valueOffset += 4];
        ++valueOffset;
        switch (bType) {
            case 0: {
                byte[] bin = new byte[totalLen];
                System.arraycopy(this._data, valueOffset, bin, 0, bin.length);
                return bin;
            }
            case 2: {
                int len = Bits.readInt(this._data, valueOffset);
                byte[] bin = new byte[len];
                System.arraycopy(this._data, valueOffset += 4, bin, 0, bin.length);
                return bin;
            }
            case 3: {
                if (totalLen != 16) {
                    throw new IllegalArgumentException("bad data size subtype 3 len: " + totalLen + " != 16");
                }
                long part1 = Bits.readLong(this._data, valueOffset);
                long part2 = Bits.readLong(this._data, valueOffset += 8);
                return new UUID(part1, part2);
            }
        }
        byte[] bin = new byte[totalLen];
        System.arraycopy(this._data, valueOffset, bin, 0, bin.length);
        return new Binary(bType, bin);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class LazyBSONKeySet
    implements Set<String> {
        @Override
        public int size() {
            int size = 0;
            for (String key : this) {
                ++size;
            }
            return size;
        }

        @Override
        public boolean isEmpty() {
            return LazyBSONObject.this.isEmpty();
        }

        @Override
        public boolean contains(Object o) {
            for (String key : this) {
                if (!key.equals(o)) continue;
                return true;
            }
            return false;
        }

        @Override
        public Iterator<String> iterator() {
            return new LazyBSONIterator();
        }

        @Override
        public Object[] toArray() {
            String[] array = new String[this.size()];
            return this.toArray(array);
        }

        @Override
        public <T> T[] toArray(T[] ts) {
            int i = 0;
            for (String key : this) {
                ts[++i] = key;
            }
            return ts;
        }

        @Override
        public boolean add(String e) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public boolean remove(Object o) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public boolean containsAll(Collection<?> clctn) {
            for (Object item : clctn) {
                if (this.contains(item)) continue;
                return false;
            }
            return true;
        }

        @Override
        public boolean addAll(Collection<? extends String> clctn) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public boolean retainAll(Collection<?> clctn) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public boolean removeAll(Collection<?> clctn) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public void clear() {
            throw new UnsupportedOperationException("Not supported yet.");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class LazyBSONIterator
    implements Iterator<String> {
        int offset = 4;

        @Override
        public boolean hasNext() {
            return !LazyBSONObject.this.isElementEmpty(this.offset);
        }

        @Override
        public String next() {
            String key = LazyBSONObject.this.getElementFieldName(this.offset);
            this.offset += LazyBSONObject.this.getElementBSONSize(this.offset);
            return key;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Not supported yet.");
        }
    }
}

