/*
 * Decompiled with CFR 0.152.
 */
package com.monitorjbl.json;

import com.fasterxml.jackson.annotation.JsonBackReference;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonManagedReference;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.monitorjbl.json.JsonView;
import com.monitorjbl.json.Match;
import com.monitorjbl.json.MatcherBehavior;
import com.monitorjbl.json.Memoizer;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.math.BigDecimal;
import java.net.URI;
import java.net.URL;
import java.time.temporal.Temporal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.UUID;
import java.util.regex.Pattern;

public class JsonViewSerializer
extends JsonSerializer<JsonView> {
    private final Memoizer memoizer;
    private Map<Class<?>, JsonSerializer<Object>> customSerializersMap = null;
    private MatcherBehavior defaultMatcherBehavior = MatcherBehavior.CLASS_FIRST;

    public JsonViewSerializer() {
        this(1024);
    }

    public JsonViewSerializer(int maxCacheSize) {
        this.memoizer = new Memoizer(maxCacheSize);
    }

    public <T> void registerCustomSerializer(Class<T> cls, JsonSerializer<T> forType) {
        if (this.customSerializersMap == null) {
            this.customSerializersMap = new HashMap();
        }
        if (cls == null) {
            throw new IllegalArgumentException("Class must not be null");
        }
        if (cls.equals(JsonView.class)) {
            throw new IllegalArgumentException("Class cannot be " + JsonView.class);
        }
        if (this.customSerializersMap.containsKey(cls)) {
            throw new IllegalArgumentException("Class " + cls + " already has a serializer registered (" + this.customSerializersMap.get(cls) + ")");
        }
        this.customSerializersMap.put(cls, forType);
    }

    public void unregisterCustomSerializer(Class<?> cls) {
        if (this.customSerializersMap != null) {
            this.customSerializersMap.remove(cls);
        }
    }

    public void setDefaultMatcherBehavior(MatcherBehavior defaultMatcherBehavior) {
        this.defaultMatcherBehavior = defaultMatcherBehavior;
    }

    public void serialize(JsonView result, JsonGenerator jgen, SerializerProvider serializers) throws IOException {
        new JsonWriter(serializers, jgen, result).write(null, result.getValue());
    }

    private static class MatchPrefixTuple {
        private final Match match;
        private final String prefix;

        public MatchPrefixTuple(Match match, String prefix) {
            this.match = match;
            this.prefix = prefix;
        }
    }

    class JsonWriter {
        Stack<String> path = new Stack();
        String currentPath = "";
        Match currentMatch = null;
        Field referringField = null;
        final SerializerProvider serializerProvider;
        final JsonGenerator jgen;
        final JsonView result;

        JsonWriter(SerializerProvider serializerProvider, JsonGenerator jgen, JsonView result) {
            this.serializerProvider = serializerProvider;
            this.jgen = jgen;
            this.result = result;
        }

        private JsonWriter(JsonGenerator jgen, JsonView result, Match currentMatch, SerializerProvider serializerProvider) {
            this.jgen = jgen;
            this.result = result;
            this.currentMatch = currentMatch;
            this.serializerProvider = serializerProvider;
        }

        private JsonWriter(JsonGenerator jgen, JsonView result, Match currentMatch, String currentPath, Stack<String> path, Field referringField, SerializerProvider serializerProvider) {
            this.jgen = jgen;
            this.result = result;
            this.currentMatch = currentMatch;
            this.currentPath = currentPath;
            this.referringField = referringField;
            this.path = path;
            this.serializerProvider = serializerProvider;
        }

        boolean writePrimitive(Object obj) throws IOException {
            if (obj instanceof String) {
                this.jgen.writeString((String)obj);
            } else if (obj instanceof Integer) {
                this.jgen.writeNumber(((Integer)obj).intValue());
            } else if (obj instanceof Long) {
                this.jgen.writeNumber(((Long)obj).longValue());
            } else if (obj instanceof Short) {
                this.jgen.writeNumber(((Short)obj).shortValue());
            } else if (obj instanceof Double) {
                this.jgen.writeNumber(((Double)obj).doubleValue());
            } else if (obj instanceof Float) {
                this.jgen.writeNumber(((Float)obj).floatValue());
            } else if (obj instanceof Character) {
                this.jgen.writeNumber((int)((Character)obj).charValue());
            } else if (obj instanceof Byte) {
                this.jgen.writeNumber((short)((Byte)obj).byteValue());
            } else if (obj instanceof Boolean) {
                this.jgen.writeBoolean(((Boolean)obj).booleanValue());
            } else if (obj == null) {
                this.jgen.writeNull();
            } else if (obj instanceof BigDecimal) {
                this.jgen.writeNumber((BigDecimal)obj);
            } else {
                return false;
            }
            return true;
        }

        boolean writeSpecial(Object obj) throws IOException {
            if (obj instanceof Date) {
                this.serializerProvider.defaultSerializeDateValue((Date)obj, this.jgen);
            } else if (obj instanceof Temporal) {
                this.serializerProvider.defaultSerializeValue(obj, this.jgen);
            } else if (obj instanceof URL) {
                this.jgen.writeString(obj.toString());
            } else if (obj instanceof URI) {
                this.jgen.writeString(obj.toString());
            } else if (obj instanceof UUID) {
                this.jgen.writeString(obj.toString());
            } else if (obj instanceof Class) {
                this.jgen.writeString(((Class)obj).getCanonicalName());
            } else {
                return false;
            }
            return true;
        }

        boolean writeEnum(Object obj) throws IOException {
            if (!obj.getClass().isEnum()) {
                return false;
            }
            this.jgen.writeString(((Enum)obj).name());
            return true;
        }

        boolean writeList(Object obj) throws IOException {
            if (obj instanceof List || obj instanceof Set || obj.getClass().isArray()) {
                Iterable iter;
                if (obj.getClass().isArray()) {
                    if (obj instanceof byte[]) {
                        this.jgen.writeBinary((byte[])obj);
                        return true;
                    }
                    iter = this.convertArray(obj);
                } else {
                    iter = (Iterable)obj;
                }
                this.jgen.writeStartArray();
                for (Object o : iter) {
                    new JsonWriter(this.jgen, this.result, this.currentMatch, this.currentPath, this.path, this.referringField, this.serializerProvider).write(null, o);
                }
            } else {
                return false;
            }
            this.jgen.writeEndArray();
            return true;
        }

        Iterable convertArray(Object obj) {
            List<Object> iter;
            if (obj instanceof int[]) {
                int[] arr = (int[])obj;
                iter = new ArrayList();
                for (int v : arr) {
                    ((List)iter).add(v);
                }
            } else if (obj instanceof double[]) {
                double[] arr = (double[])obj;
                iter = new ArrayList();
                for (double v : arr) {
                    ((List)iter).add(v);
                }
            } else if (obj instanceof float[]) {
                float[] arr = (float[])obj;
                iter = new ArrayList();
                for (float v : arr) {
                    ((List)iter).add(Float.valueOf(v));
                }
            } else if (obj instanceof long[]) {
                long[] arr = (long[])obj;
                iter = new ArrayList();
                for (long v : arr) {
                    ((List)iter).add(v);
                }
            } else if (obj instanceof short[]) {
                short[] arr = (short[])obj;
                iter = new ArrayList();
                for (short v : arr) {
                    ((List)iter).add(v);
                }
            } else if (obj instanceof char[]) {
                char[] arr = (char[])obj;
                iter = new ArrayList();
                for (char v : arr) {
                    ((List)iter).add(Character.valueOf(v));
                }
            } else if (obj instanceof boolean[]) {
                boolean[] arr = (boolean[])obj;
                iter = new ArrayList();
                for (boolean v : arr) {
                    ((List)iter).add(v);
                }
            } else {
                iter = Arrays.asList((Object[])obj);
            }
            return iter;
        }

        boolean writeMap(Object obj) throws IOException {
            if (obj instanceof Map) {
                Map map = (Map)obj;
                this.jgen.writeStartObject();
                for (Object key : map.keySet()) {
                    this.jgen.writeFieldName(key.toString());
                    new JsonWriter(this.jgen, this.result, this.currentMatch, this.serializerProvider).write(null, map.get(key));
                }
            } else {
                return false;
            }
            this.jgen.writeEndObject();
            return true;
        }

        void writeObject(Object obj) throws IOException {
            this.jgen.writeStartObject();
            Class<?> cls = obj.getClass();
            while (!cls.equals(Object.class)) {
                Field[] fields;
                for (Field field : fields = this.getDeclaredFields(cls)) {
                    try {
                        Object val;
                        field.setAccessible(true);
                        if (!this.fieldAllowed(field, obj.getClass()) || !this.valueAllowed(val = this.readField(obj, field), obj.getClass())) continue;
                        String name = this.getFieldName(field);
                        this.jgen.writeFieldName(name);
                        JsonSerializer fieldSerializer = this.annotatedWithJsonSerialize(field);
                        if (fieldSerializer != null) {
                            fieldSerializer.serialize(val, this.jgen, this.serializerProvider);
                            continue;
                        }
                        if (JsonViewSerializer.this.customSerializersMap != null && val != null) {
                            JsonSerializer serializer = (JsonSerializer)JsonViewSerializer.this.customSerializersMap.get(val.getClass());
                            if (serializer != null) {
                                serializer.serialize(val, this.jgen, this.serializerProvider);
                                continue;
                            }
                            new JsonWriter(this.jgen, this.result, this.currentMatch, this.currentPath, this.path, field, this.serializerProvider).write(name, val);
                            continue;
                        }
                        new JsonWriter(this.jgen, this.result, this.currentMatch, this.currentPath, this.path, field, this.serializerProvider).write(name, val);
                    }
                    catch (IllegalAccessException | IllegalArgumentException e) {
                        throw new RuntimeException(e);
                    }
                }
                cls = cls.getSuperclass();
            }
            this.jgen.writeEndObject();
        }

        boolean valueAllowed(Object value, Class cls) {
            return value != null || this.serializerProvider.getConfig() != null && this.serializerProvider.getConfig().getSerializationInclusion() == JsonInclude.Include.ALWAYS && this.getAnnotation(cls, JsonSerialize.class) == null || this.getAnnotation(cls, JsonSerialize.class) != null && this.readClassAnnotation(cls, JsonSerialize.class, "include") == JsonSerialize.Inclusion.ALWAYS;
        }

        private Match classMatchSearch(Class declaringClass) {
            Match match = null;
            Class cls = declaringClass;
            while (!cls.equals(Object.class) && match == null) {
                match = this.result.getMatch(cls);
                if (match == null && this.getInterfaces(cls) != null) {
                    Class<?> iface;
                    Class<?>[] classArray = this.getInterfaces(cls);
                    int n = classArray.length;
                    for (int i = 0; i < n && (match = this.result.getMatch(iface = classArray[i])) == null; ++i) {
                    }
                }
                cls = cls.getSuperclass();
            }
            return match;
        }

        boolean fieldAllowed(Field field, Class declaringClass) {
            String name = field.getName();
            if (Modifier.isStatic(field.getModifiers())) {
                return false;
            }
            MatchPrefixTuple tuple = this.getMatchPrefix(declaringClass);
            String prefix = tuple.prefix;
            Match match = tuple.match;
            if (match != null) {
                if (this.currentMatch == null) {
                    this.currentMatch = match;
                }
                int included = this.containsMatchingPattern(match.getIncludes(), prefix + name, true);
                int excluded = this.containsMatchingPattern(match.getExcludes(), prefix + name, false);
                if (included == 1) {
                    return true;
                }
                if (excluded == 1) {
                    return false;
                }
                if (included == 0) {
                    return true;
                }
                if (excluded == 0) {
                    return false;
                }
                return !this.annotatedWithIgnore(field);
            }
            return !this.annotatedWithIgnore(field);
        }

        MatchPrefixTuple getMatchPrefix(Class declaringClass) {
            String prefix = this.currentPath.length() > 0 ? this.currentPath + "." : "";
            MatcherBehavior currentBehavior = this.result.matcherBehavior;
            if (currentBehavior == null) {
                currentBehavior = JsonViewSerializer.this.defaultMatcherBehavior;
            }
            Match match = null;
            if (currentBehavior == MatcherBehavior.CLASS_FIRST) {
                match = this.classMatchSearch(declaringClass);
                if (match == null) {
                    match = this.currentMatch;
                } else {
                    prefix = "";
                }
            } else if (currentBehavior == MatcherBehavior.PATH_FIRST) {
                if (this.currentMatch != null) {
                    match = this.currentMatch;
                } else {
                    match = this.classMatchSearch(declaringClass);
                    prefix = "";
                }
            }
            return new MatchPrefixTuple(match, prefix);
        }

        Object readField(Object obj, Field field) throws IllegalAccessException {
            MatchPrefixTuple tuple = this.getMatchPrefix(obj.getClass());
            if (tuple.match != null && tuple.match.getTransforms().containsKey(tuple.prefix + field.getName())) {
                return tuple.match.getTransforms().get(tuple.prefix + field.getName()).apply(obj, field.get(obj));
            }
            return field.get(obj);
        }

        void write(String fieldName, Object value) throws IOException {
            if (fieldName != null) {
                this.path.push(fieldName);
                this.updateCurrentPath();
            }
            if (!(this.writePrimitive(value) || this.writeSpecial(value) || this.writeEnum(value) || this.writeList(value) || this.writeMap(value))) {
                this.writeObject(value);
            }
            if (fieldName != null) {
                this.path.pop();
                this.updateCurrentPath();
            }
        }

        void updateCurrentPath() {
            StringBuilder builder = new StringBuilder();
            for (String s : this.path) {
                builder.append(".");
                builder.append(s);
            }
            this.currentPath = builder.length() > 0 ? builder.toString().substring(1) : "";
        }

        <E> E readClassAnnotation(Class cls, Class annotationType, String methodName) {
            try {
                for (Annotation an : this.getAnnotations(cls)) {
                    Class<? extends Annotation> type = an.annotationType();
                    if (!an.annotationType().equals(annotationType)) continue;
                    for (Method method : type.getDeclaredMethods()) {
                        if (!method.getName().equals(methodName)) continue;
                        return (E)method.invoke((Object)an, (Object[])null);
                    }
                    throw new IllegalArgumentException("Method " + methodName + " not found on annotation " + annotationType);
                }
                throw new IllegalArgumentException("Annotation " + annotationType + " not found on class " + cls);
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                throw new RuntimeException(e);
            }
        }

        int containsMatchingPattern(Set<String> values, String pattern, boolean matchPrefix) {
            return JsonViewSerializer.this.memoizer.matches(values, pattern, matchPrefix, () -> {
                int match = -1;
                for (String val : values) {
                    String replaced = val.replaceAll("\\.", "\\\\.").replaceAll("\\*", ".*");
                    if (!Pattern.compile(replaced).matcher(pattern).matches() && (!matchPrefix || !val.startsWith(pattern + "."))) continue;
                    match = replaced.contains("*") ? 0 : 1;
                    break;
                }
                return match;
            });
        }

        boolean annotatedWithIgnore(Field f) {
            return JsonViewSerializer.this.memoizer.ignoreAnnotations(f, () -> {
                JsonIgnore jsonIgnore = this.getAnnotation(f, JsonIgnore.class);
                JsonIgnoreProperties classIgnoreProperties = this.getAnnotation(f.getDeclaringClass(), JsonIgnoreProperties.class);
                JsonIgnoreProperties fieldIgnoreProperties = null;
                boolean backReferenced = false;
                if (this.referringField != null) {
                    fieldIgnoreProperties = this.getAnnotation(this.referringField, JsonIgnoreProperties.class);
                }
                if (this.getAnnotation(f, JsonBackReference.class) != null && this.referringField != null) {
                    for (Field lastField : this.getDeclaredFields(this.referringField.getDeclaringClass())) {
                        JsonManagedReference fieldManagedReference = this.getAnnotation(lastField, JsonManagedReference.class);
                        if (fieldManagedReference == null || !lastField.getType().equals(f.getDeclaringClass())) continue;
                        backReferenced = true;
                        break;
                    }
                }
                return jsonIgnore != null && jsonIgnore.value() || classIgnoreProperties != null && Arrays.asList(classIgnoreProperties.value()).contains(f.getName()) || fieldIgnoreProperties != null && Arrays.asList(fieldIgnoreProperties.value()).contains(f.getName()) || backReferenced;
            });
        }

        JsonSerializer annotatedWithJsonSerialize(Field f) {
            return JsonViewSerializer.this.memoizer.serializeAnnotations(f, () -> {
                JsonSerialize jsonSerialize = this.getAnnotation(f, JsonSerialize.class);
                if (jsonSerialize != null && !jsonSerialize.using().equals(JsonSerializer.None.class)) {
                    try {
                        return (JsonSerializer)jsonSerialize.using().newInstance();
                    }
                    catch (IllegalAccessException | InstantiationException e) {
                        throw new RuntimeException(e);
                    }
                }
                return null;
            });
        }

        private Class<?>[] getInterfaces(Class cls) {
            return cls.getInterfaces();
        }

        private Field[] getDeclaredFields(Class cls) {
            return cls.getDeclaredFields();
        }

        private Annotation[] getAnnotations(Class cls) {
            return cls.getAnnotations();
        }

        private Annotation[] getAnnotations(Field field) {
            return field.getAnnotations();
        }

        private String getFieldName(Field field) {
            return JsonViewSerializer.this.memoizer.fieldName(field, () -> {
                JsonProperty jsonProperty = field.getAnnotation(JsonProperty.class);
                if (jsonProperty != null && jsonProperty.value().length() > 0) {
                    return jsonProperty.value();
                }
                return field.getName();
            });
        }

        private <T extends Annotation> T getAnnotation(Class cls, Class<T> annotation) {
            Annotation[] annotations = this.getAnnotations(cls);
            if (annotations != null) {
                for (Annotation a : annotations) {
                    if (!a.annotationType().equals(annotation)) continue;
                    return (T)a;
                }
            }
            return null;
        }

        private <T extends Annotation> T getAnnotation(Field field, Class<T> annotation) {
            Annotation[] annotations = this.getAnnotations(field);
            if (annotations != null) {
                for (Annotation a : annotations) {
                    if (!a.annotationType().equals(annotation)) continue;
                    return (T)a;
                }
            }
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private <T, V> Map<T, V> fitToMaxSize(Map<T, V> map) {
            Map<T, V> map2 = map;
            synchronized (map2) {
                if (map.size() > 1) {
                    map.remove(map.keySet().iterator().next());
                }
            }
            return map;
        }
    }
}

