/*
 * Decompiled with CFR 0.152.
 */
package com.monitorjbl.json;

import java.lang.reflect.Field;
import java.util.EnumMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Supplier;

class Memoizer {
    private final int maxCacheSize;
    private final Map<FunctionCache, Map<Arg, Object>> cache = new EnumMap<FunctionCache, Map<Arg, Object>>(FunctionCache.class);

    public Memoizer(int maxCacheSize) {
        this.maxCacheSize = maxCacheSize;
        for (FunctionCache key : (FunctionCache[])FunctionCache.class.getEnumConstants()) {
            this.cache.put(key, new ConcurrentHashMap());
        }
    }

    public <T> T ignoreAnnotations(Field f, Supplier<T> compute) {
        return (T)this.fitToMaxSize(FunctionCache.IGNORE_ANNOTATIONS).computeIfAbsent(new MonoArg(f), k -> compute.get());
    }

    public <T> T serializeAnnotations(Field f, Supplier<T> compute) {
        return (T)this.fitToMaxSize(FunctionCache.SERIALIZE_ANNOTATIONS).computeIfAbsent(new MonoArg(f), k -> compute.get());
    }

    public <T> T matches(Set<String> values, String pattern, boolean matchPrefix, Supplier<T> compute) {
        return (T)this.fitToMaxSize(FunctionCache.MATCHES).computeIfAbsent(new TriArg(values, pattern, matchPrefix), k -> compute.get());
    }

    public <T> T fieldName(Field f, Supplier<T> compute) {
        return (T)this.fitToMaxSize(FunctionCache.FIELD_NAME).computeIfAbsent(new MonoArg(f), k -> compute.get());
    }

    private Map<Arg, Object> fitToMaxSize(FunctionCache key) {
        Map<Arg, Object> map = this.cache.get((Object)key);
        if (map.size() > this.maxCacheSize) {
            map.remove(map.keySet().iterator().next());
        }
        return map;
    }

    private class TriArg
    implements Arg {
        private final Object arg1;
        private final Object arg2;
        private final Object arg3;

        public TriArg(Object arg1, Object arg2, Object arg3) {
            this.arg1 = arg1;
            this.arg2 = arg2;
            this.arg3 = arg3;
        }

        public boolean equals(Object o) {
            TriArg triArg = (TriArg)o;
            if (this.arg1 != null ? !this.arg1.equals(triArg.arg1) : triArg.arg1 != null) {
                return false;
            }
            if (this.arg2 != null ? !this.arg2.equals(triArg.arg2) : triArg.arg2 != null) {
                return false;
            }
            return this.arg3 != null ? this.arg3.equals(triArg.arg3) : triArg.arg3 == null;
        }

        public int hashCode() {
            int result = this.arg1 != null ? this.arg1.hashCode() : 0;
            result = 31 * result + (this.arg2 != null ? this.arg2.hashCode() : 0);
            result = 31 * result + (this.arg3 != null ? this.arg3.hashCode() : 0);
            return result;
        }
    }

    private class MonoArg
    implements Arg {
        private final Object arg1;

        public MonoArg(Object arg1) {
            this.arg1 = arg1;
        }

        public boolean equals(Object o) {
            MonoArg monoArg = (MonoArg)o;
            return this.arg1 != null ? this.arg1.equals(monoArg.arg1) : monoArg.arg1 == null;
        }

        public int hashCode() {
            return this.arg1 != null ? this.arg1.hashCode() : 0;
        }
    }

    private static interface Arg {
    }

    static enum FunctionCache {
        IGNORE_ANNOTATIONS,
        SERIALIZE_ANNOTATIONS,
        MATCHES,
        FIELD_NAME;

    }
}

