/*
 * Decompiled with CFR 0.152.
 */
package com.monitorjbl.json;

import com.monitorjbl.json.Match;
import com.monitorjbl.json.MatcherBehavior;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public class JsonView<T> {
    protected final T value;
    protected final Map<Class<?>, Match> matches = new HashMap();
    protected MatcherBehavior matcherBehavior;

    protected JsonView(T value) {
        this.value = value;
    }

    T getValue() {
        return this.value;
    }

    Match getMatch(Class<?> cls) {
        return this.matches.get(cls);
    }

    public JsonView<T> onClass(Class<?> cls, Match match) {
        this.matches.put(cls, match);
        return this;
    }

    public JsonView<T> withMatcherBehavior(MatcherBehavior matcherBehavior) {
        this.matcherBehavior = matcherBehavior;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JsonView jsonView = (JsonView)o;
        return Objects.equals(this.matches, jsonView.matches) && this.matcherBehavior == jsonView.matcherBehavior;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.matches, this.matcherBehavior});
    }

    public static <E> JsonView<E> with(E value) {
        return new JsonView<E>(value);
    }
}

