/*
 * Decompiled with CFR 0.152.
 */
package com.monitorjbl.json;

import com.monitorjbl.json.JsonView;
import com.monitorjbl.json.JsonViewSerializer;
import java.util.EnumMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Supplier;

class Memoizer {
    private final int maxCacheSize;
    private final Map<FunctionCache, Map<Arg, Object>> cache = new EnumMap<FunctionCache, Map<Arg, Object>>(FunctionCache.class);

    public Memoizer(int maxCacheSize) {
        this.maxCacheSize = maxCacheSize;
        for (FunctionCache key : (FunctionCache[])FunctionCache.class.getEnumConstants()) {
            this.cache.put(key, new ConcurrentHashMap());
        }
    }

    public <T> T matches(Set<String> values, String pattern, boolean matchPrefix, Supplier<T> compute) {
        return this.computeIfAbsent(FunctionCache.MATCHES, new TriArg(values, pattern, matchPrefix), compute);
    }

    public <T> T classMatches(JsonView jsonView, Class cls, Supplier<T> compute) {
        return this.computeIfAbsent(FunctionCache.CLASS_MATCHES, new BiArg(jsonView, cls), compute);
    }

    public <T> T annotations(Class cls, Supplier<T> compute) {
        return this.computeIfAbsent(FunctionCache.ANNOTATIONS, new MonoArg(cls), compute);
    }

    public <T> T annotatedWithIgnore(JsonViewSerializer.AccessibleProperty property, Supplier<T> compute) {
        return this.computeIfAbsent(FunctionCache.IGNORE_ANNOTATIONS, new MonoArg(property), compute);
    }

    public <T> T accessibleProperty(Class cls, Supplier<T> compute) {
        return this.computeIfAbsent(FunctionCache.ACCESSIBLE_PROPERTY, new MonoArg(cls), compute);
    }

    public <T> T computeIfAbsent(FunctionCache cacheName, Arg arg, Supplier<T> compute) {
        Map<Arg, Object> map = this.fitToMaxSize(cacheName);
        if (!map.containsKey(arg)) {
            map.put(arg, compute.get());
        }
        return (T)map.get(arg);
    }

    private Map<Arg, Object> fitToMaxSize(FunctionCache key) {
        Map<Arg, Object> map = this.cache.get((Object)key);
        if (map.size() > this.maxCacheSize) {
            map.remove(map.keySet().iterator().next());
        }
        return map;
    }

    private class TriArg
    implements Arg {
        private final Object arg1;
        private final Object arg2;
        private final Object arg3;

        public TriArg(Object arg1, Object arg2, Object arg3) {
            this.arg1 = arg1;
            this.arg2 = arg2;
            this.arg3 = arg3;
        }

        public boolean equals(Object o) {
            TriArg triArg = (TriArg)o;
            if (this.arg1 != null ? !this.arg1.equals(triArg.arg1) : triArg.arg1 != null) {
                return false;
            }
            if (this.arg2 != null ? !this.arg2.equals(triArg.arg2) : triArg.arg2 != null) {
                return false;
            }
            return this.arg3 != null ? this.arg3.equals(triArg.arg3) : triArg.arg3 == null;
        }

        public int hashCode() {
            int result = this.arg1 != null ? this.arg1.hashCode() : 0;
            result = 31 * result + (this.arg2 != null ? this.arg2.hashCode() : 0);
            result = 31 * result + (this.arg3 != null ? this.arg3.hashCode() : 0);
            return result;
        }

        public String toString() {
            return "TriArg{arg1=" + this.arg1 + ", arg2=" + this.arg2 + ", arg3=" + this.arg3 + '}';
        }
    }

    private class BiArg
    implements Arg {
        private final Object arg1;
        private final Object arg2;

        public BiArg(Object arg1, Object arg2) {
            this.arg1 = arg1;
            this.arg2 = arg2;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            BiArg biArg = (BiArg)o;
            return Objects.equals(this.arg1, biArg.arg1) && Objects.equals(this.arg2, biArg.arg2);
        }

        public int hashCode() {
            return Objects.hash(this.arg1, this.arg2);
        }

        public String toString() {
            return "BiArg{arg1=" + this.arg1 + ", arg2=" + this.arg2 + '}';
        }
    }

    private class MonoArg
    implements Arg {
        private final Object arg1;

        public MonoArg(Object arg1) {
            this.arg1 = arg1;
        }

        public boolean equals(Object o) {
            MonoArg monoArg = (MonoArg)o;
            return this.arg1 != null ? this.arg1.equals(monoArg.arg1) : monoArg.arg1 == null;
        }

        public int hashCode() {
            return this.arg1 != null ? this.arg1.hashCode() : 0;
        }

        public String toString() {
            return "MonoArg{arg1=" + this.arg1 + '}';
        }
    }

    private static interface Arg {
    }

    static enum FunctionCache {
        IGNORE_ANNOTATIONS,
        MATCHES,
        ANNOTATIONS,
        ACCESSIBLE_PROPERTY,
        CLASS_MATCHES;

    }
}

