/*
 * Decompiled with CFR 0.152.
 */
package com.monitorjbl.xlsx;

import com.monitorjbl.xlsx.exceptions.OpenException;
import com.monitorjbl.xlsx.exceptions.ReadException;
import com.monitorjbl.xlsx.impl.StreamingCell;
import com.monitorjbl.xlsx.impl.StreamingRow;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.Characters;
import javax.xml.stream.events.EndElement;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import org.apache.poi.openxml4j.exceptions.OpenXML4JException;
import org.apache.poi.openxml4j.opc.OPCPackage;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.util.CellReference;
import org.apache.poi.xssf.eventusermodel.XSSFReader;
import org.apache.poi.xssf.model.SharedStringsTable;
import org.apache.poi.xssf.usermodel.XSSFRichTextString;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.SAXException;

public class StreamingReader
implements Iterable<Row>,
AutoCloseable {
    private static final Logger log = LoggerFactory.getLogger(StreamingReader.class);
    private SharedStringsTable sst;
    private XMLEventReader parser;
    private String lastContents;
    private boolean nextIsString;
    private int rowCacheSize;
    private int bufferSize;
    private List<Row> rowCache = new ArrayList<Row>();
    private Iterator<Row> rowCacheIterator;
    private StreamingRow currentRow;
    private StreamingCell currentCell;
    private File tmp;

    private StreamingReader(SharedStringsTable sst, XMLEventReader parser, int rowCacheSize, int bufferSize) {
        this.sst = sst;
        this.parser = parser;
        this.rowCacheSize = rowCacheSize;
        this.bufferSize = bufferSize;
    }

    private boolean getRow() {
        try {
            int iters = 0;
            this.rowCache = new ArrayList<Row>();
            while (this.rowCache.size() < this.rowCacheSize && this.parser.hasNext()) {
                this.handleEvent(this.parser.nextEvent());
                ++iters;
            }
            this.rowCache.add(this.currentRow);
            this.rowCacheIterator = this.rowCache.iterator();
            return iters > 0;
        }
        catch (XMLStreamException | SAXException e) {
            log.debug("End of stream");
            return false;
        }
    }

    private void handleEvent(XMLEvent event) throws SAXException {
        if (event.getEventType() == 4) {
            Characters c = event.asCharacters();
            this.lastContents = this.lastContents + c.getData();
        } else if (event.getEventType() == 1) {
            StartElement startElement = event.asStartElement();
            if (startElement.getName().getLocalPart().equals("c")) {
                Attribute ref = startElement.getAttributeByName(new QName("r"));
                String[] coord = ref.getValue().split("(?<=\\D)(?=\\d)|(?<=\\d)(?=\\D)");
                StreamingCell cc = new StreamingCell(CellReference.convertColStringToIndex((String)coord[0]), Integer.parseInt(coord[1]) - 1);
                if (this.currentCell == null || this.currentCell.getRowIndex() != cc.getRowIndex()) {
                    if (this.currentRow != null) {
                        this.rowCache.add(this.currentRow);
                    }
                    this.currentRow = new StreamingRow(cc.getRowIndex());
                }
                this.currentCell = cc;
                Attribute type = startElement.getAttributeByName(new QName("t"));
                String cellType = type == null ? null : type.getValue();
                this.nextIsString = cellType != null && cellType.equals("s");
            }
            this.lastContents = "";
        } else if (event.getEventType() == 2) {
            EndElement endElement = event.asEndElement();
            if (this.nextIsString) {
                int idx = Integer.parseInt(this.lastContents);
                this.lastContents = new XSSFRichTextString(this.sst.getEntryAt(idx)).toString();
                this.nextIsString = false;
            }
            if (endElement.getName().getLocalPart().equals("v")) {
                this.currentCell.setContents(this.lastContents);
                this.currentRow.getCellMap().put(this.currentCell.getColumnIndex(), this.currentCell);
            }
        }
    }

    @Override
    public Iterator<Row> iterator() {
        return new StreamingIterator();
    }

    @Override
    public void close() {
        if (this.tmp != null) {
            log.debug("Deleting tmp file [" + this.tmp.getAbsolutePath() + "]");
            this.tmp.delete();
        }
    }

    static File writeInputStreamToFile(InputStream is, int bufferSize) throws IOException {
        File f = Files.createTempFile("tmp-", ".xlsx", new FileAttribute[0]).toFile();
        try (FileOutputStream fos = new FileOutputStream(f);){
            int read;
            byte[] bytes = new byte[bufferSize];
            while ((read = is.read(bytes)) != -1) {
                fos.write(bytes, 0, read);
            }
            is.close();
            fos.close();
            File file = f;
            return file;
        }
    }

    public static Builder builder() {
        return new Builder();
    }

    class StreamingIterator
    implements Iterator<Row> {
        StreamingIterator() {
        }

        @Override
        public boolean hasNext() {
            return StreamingReader.this.rowCacheIterator != null && StreamingReader.this.rowCacheIterator.hasNext() || StreamingReader.this.getRow();
        }

        @Override
        public Row next() {
            return (Row)StreamingReader.this.rowCacheIterator.next();
        }

        @Override
        public void remove() {
            throw new RuntimeException("NotSupported");
        }
    }

    public static class Builder {
        int rowCacheSize = 10;
        int bufferSize = 1024;
        int sheetIndex = 0;

        public Builder rowCacheSize(int rowCacheSize) {
            this.rowCacheSize = rowCacheSize;
            return this;
        }

        public Builder bufferSize(int bufferSize) {
            this.bufferSize = bufferSize;
            return this;
        }

        public Builder sheetIndex(int sheetIndex) {
            this.sheetIndex = sheetIndex;
            return this;
        }

        public StreamingReader read(InputStream is) {
            try {
                File f = StreamingReader.writeInputStreamToFile(is, this.bufferSize);
                log.debug("Created temp file [" + f.getAbsolutePath() + "]");
                StreamingReader r = this.read(f);
                r.tmp = f;
                return r;
            }
            catch (IOException e) {
                throw new ReadException("Unable to read input stream", e);
            }
        }

        public StreamingReader read(File f) {
            try {
                OPCPackage pkg = OPCPackage.open((File)f);
                XSSFReader reader = new XSSFReader(pkg);
                SharedStringsTable sst = reader.getSharedStringsTable();
                Iterator iter = reader.getSheetsData();
                InputStream sheet = null;
                int index = 0;
                while (iter.hasNext()) {
                    InputStream is = (InputStream)iter.next();
                    if (index++ != this.sheetIndex) continue;
                    sheet = is;
                    log.debug("Found sheet at index [" + this.sheetIndex + "]");
                    break;
                }
                if (sheet == null) {
                    throw new RuntimeException("Unable to find sheet at index [" + this.sheetIndex + "]");
                }
                XMLEventReader parser = XMLInputFactory.newInstance().createXMLEventReader(sheet);
                return new StreamingReader(sst, parser, this.rowCacheSize, this.bufferSize);
            }
            catch (IOException e) {
                throw new OpenException("Failed to open file", e);
            }
            catch (XMLStreamException | OpenXML4JException e) {
                throw new ReadException("Unable to read workbook", (Exception)e);
            }
        }
    }
}

