/*
 * Decompiled with CFR 0.152.
 */
package com.montrosesoftware.dbassist.types;

import java.sql.CallableStatement;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Comparator;
import java.util.Date;
import java.util.TimeZone;
import org.hibernate.HibernateException;
import org.hibernate.dialect.Dialect;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.type.AbstractSingleColumnStandardBasicType;
import org.hibernate.type.LiteralType;
import org.hibernate.type.TimestampType;
import org.hibernate.type.VersionType;
import org.hibernate.type.descriptor.ValueBinder;
import org.hibernate.type.descriptor.ValueExtractor;
import org.hibernate.type.descriptor.WrapperOptions;
import org.hibernate.type.descriptor.java.JavaTypeDescriptor;
import org.hibernate.type.descriptor.java.JdbcTimestampTypeDescriptor;
import org.hibernate.type.descriptor.sql.BasicBinder;
import org.hibernate.type.descriptor.sql.BasicExtractor;
import org.hibernate.type.descriptor.sql.SqlTypeDescriptor;
import org.hibernate.type.descriptor.sql.TimestampTypeDescriptor;

public class UtcDateType
extends AbstractSingleColumnStandardBasicType<Date>
implements VersionType<Date>,
LiteralType<Date> {
    public UtcDateType() {
        super((SqlTypeDescriptor)UtcTimestampTypeDescriptor.INSTANCE, (JavaTypeDescriptor)JdbcTimestampTypeDescriptor.INSTANCE);
    }

    public String getName() {
        return TimestampType.INSTANCE.getName();
    }

    public String[] getRegistrationKeys() {
        return TimestampType.INSTANCE.getRegistrationKeys();
    }

    public Date seed(SharedSessionContractImplementor sharedSessionContractImplementor) {
        return TimestampType.INSTANCE.seed(sharedSessionContractImplementor);
    }

    public Date next(Date date, SharedSessionContractImplementor sharedSessionContractImplementor) {
        return TimestampType.INSTANCE.next(date, sharedSessionContractImplementor);
    }

    public Comparator<Date> getComparator() {
        return TimestampType.INSTANCE.getComparator();
    }

    public String objectToSQLString(Date value, Dialect dialect) throws Exception {
        return TimestampType.INSTANCE.objectToSQLString(value, dialect);
    }

    public Date fromStringValue(String xml) throws HibernateException {
        return TimestampType.INSTANCE.fromStringValue(xml);
    }

    public static class UtcTimestampTypeDescriptor
    extends TimestampTypeDescriptor {
        public static final UtcTimestampTypeDescriptor INSTANCE = new UtcTimestampTypeDescriptor();
        private static final TimeZone UTC = TimeZone.getTimeZone("UTC");

        public <X> ValueBinder<X> getBinder(final JavaTypeDescriptor<X> javaTypeDescriptor) {
            return new BasicBinder<X>(javaTypeDescriptor, (SqlTypeDescriptor)this){

                protected void doBind(PreparedStatement st, X value, int index, WrapperOptions options) throws SQLException {
                    st.setTimestamp(index, (Timestamp)javaTypeDescriptor.unwrap(value, Timestamp.class, options), Calendar.getInstance(UTC));
                }

                protected void doBind(CallableStatement callableStatement, X value, String paramName, WrapperOptions wrapperOptions) throws SQLException {
                    callableStatement.setTimestamp(paramName, (Timestamp)javaTypeDescriptor.unwrap(value, Timestamp.class, wrapperOptions), Calendar.getInstance(UTC));
                }
            };
        }

        public <X> ValueExtractor<X> getExtractor(final JavaTypeDescriptor<X> javaTypeDescriptor) {
            return new BasicExtractor<X>(javaTypeDescriptor, (SqlTypeDescriptor)this){

                protected X doExtract(CallableStatement statement, String name, WrapperOptions options) throws SQLException {
                    return javaTypeDescriptor.wrap((Object)statement.getTimestamp(name, Calendar.getInstance(UTC)), options);
                }

                protected X doExtract(ResultSet rs, String name, WrapperOptions options) throws SQLException {
                    return javaTypeDescriptor.wrap((Object)rs.getTimestamp(name, Calendar.getInstance(UTC)), options);
                }

                protected X doExtract(CallableStatement statement, int index, WrapperOptions options) throws SQLException {
                    return javaTypeDescriptor.wrap((Object)statement.getTimestamp(index, Calendar.getInstance(UTC)), options);
                }
            };
        }
    }
}

