/*
 * Decompiled with CFR 0.152.
 */
package com.mooltiverse.oss.nyx.version;

import com.mooltiverse.oss.nyx.version.Identifier;
import com.mooltiverse.oss.nyx.version.Parser;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;

abstract class CompositeIdentifier
extends Identifier {
    private static final long serialVersionUID = 1L;
    protected final List<? extends Identifier> children;
    private transient String renderedString = null;
    protected final char separator;
    public static final char DEFAULT_SEPARATOR = '.';

    @SafeVarargs
    protected CompositeIdentifier(char separator, Identifier ... children) {
        this.separator = separator;
        this.children = Parser.validateElements(Arrays.asList(children));
    }

    @SafeVarargs
    protected CompositeIdentifier(Identifier ... children) {
        this('.', children);
    }

    protected CompositeIdentifier(char separator, List<? extends Identifier> children) {
        this.separator = separator;
        this.children = Parser.validateElements(children);
    }

    protected CompositeIdentifier(List<? extends Identifier> children) {
        this('.', children);
    }

    @Override
    public List<? extends Identifier> getValue() {
        return this.children;
    }

    public List<Object> getValues() {
        ArrayList<Object> values = new ArrayList<Object>(this.children.size());
        for (Identifier identifier : this.children) {
            values.add(identifier.getValue());
        }
        return values;
    }

    @Override
    public int hashCode() {
        return 31 * Character.valueOf(this.separator).hashCode() + 37 * this.children.hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (!this.getClass().isInstance(obj)) {
            return false;
        }
        return this.children.equals(((CompositeIdentifier)this.getClass().cast((Object)obj)).children);
    }

    @Override
    public String toString() {
        if (this.renderedString == null) {
            StringBuilder sb = new StringBuilder();
            Iterator<? extends Identifier> i = this.children.iterator();
            while (i.hasNext()) {
                sb.append(i.next().toString());
                if (!i.hasNext()) continue;
                sb.append(this.separator);
            }
            this.renderedString = sb.toString();
        }
        return this.renderedString;
    }
}

