/*
 * Decompiled with CFR 0.152.
 */
package com.mooltiverse.oss.nyx.version;

import com.mooltiverse.oss.nyx.version.IntegerIdentifier;
import com.mooltiverse.oss.nyx.version.SimpleIdentifier;
import com.mooltiverse.oss.nyx.version.StringIdentifier;
import com.mooltiverse.oss.nyx.version.UseIntegerIdentifiers;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

final class Parser {
    static final String ALLOWED_ALPHANUMERIC_CHARACTERS = "[0-9a-zA-Z-]";
    static final String ALLOWED_ALPHANUMERIC_CHARACTERS_REGEXP_PATTERN = "^[0-9a-zA-Z-]+$";

    private Parser() {
    }

    static String validateStringIdentifier(String value) {
        Objects.requireNonNull(value, "Identifier value cannot be null");
        if (value.isBlank()) {
            throw new IllegalArgumentException("Identifier value cannot be empty");
        }
        if (!value.matches(ALLOWED_ALPHANUMERIC_CHARACTERS_REGEXP_PATTERN)) {
            throw new IllegalArgumentException(String.format("Illegal value '%s' for string identifier. Illegal characters have been found. Allowed characters are limited to [0-9a-zA-Z-].", value));
        }
        return value;
    }

    static Integer validateIntegerIdentifier(Integer value, boolean allowNegative) {
        Objects.requireNonNull(value, "Identifier value cannot be null");
        if (!allowNegative && value < 0) {
            throw new IllegalArgumentException(String.format("Illegal value '%d' for integer identifier. Value cannot be negative.", value));
        }
        return value;
    }

    static Integer validateIntegerIdentifier(String value, boolean allowNegative, boolean allowExtraCharacters) {
        Objects.requireNonNull(value, "Identifier value cannot be null");
        if (value.isBlank()) {
            throw new IllegalArgumentException("Identifier value cannot be empty");
        }
        Integer intValue = null;
        try {
            intValue = Integer.valueOf(value);
        }
        catch (NumberFormatException nfe) {
            throw new IllegalArgumentException(String.format("Illegal value '%s' for integer identifier. Not a valid Integer.", value), nfe);
        }
        if (!value.equals(intValue.toString())) {
            throw new IllegalArgumentException(String.format("Illegal value '%s' for integer identifier. Value should be '%d'. Consider sanitizing the string before parsing.", value, intValue));
        }
        return Parser.validateIntegerIdentifier(intValue, allowNegative);
    }

    static <T> List<T> validateElements(List<T> elements) {
        Objects.requireNonNull(elements, "Elements list cannot be null");
        if (elements.isEmpty()) {
            throw new IllegalArgumentException("Elements list cannot be empty");
        }
        return elements;
    }

    static String[] split(String s, char separator) {
        Objects.requireNonNull(s, "Can't split null string");
        if (s.isBlank()) {
            throw new IllegalArgumentException("Can't split an empty string");
        }
        return s.split("[" + separator + "]");
    }

    static boolean hasValues(Object[] items) {
        if (items == null || items.length == 0) {
            return false;
        }
        for (Object item : items) {
            if (item != null) continue;
            return false;
        }
        return true;
    }

    static List<StringIdentifier> toStringIdentifiers(String s, char separator) {
        Objects.requireNonNull(s, "Can't parse null string");
        if (s.isBlank()) {
            throw new IllegalArgumentException("Can't parse an empty string");
        }
        return Parser.toStringIdentifiers(Parser.split(s, separator));
    }

    static List<StringIdentifier> toStringIdentifiers(String[] s) {
        Objects.requireNonNull(s, "Can't parse null string array");
        if (s.length == 0) {
            throw new IllegalArgumentException("Can't parse an empty string array");
        }
        ArrayList<StringIdentifier> identifiers = new ArrayList<StringIdentifier>();
        for (String part : s) {
            identifiers.add(StringIdentifier.valueOf(part));
        }
        return identifiers;
    }

    static List<IntegerIdentifier> toIntegerIdentifiers(String s, char separator) {
        Objects.requireNonNull(s, "Can't parse null string");
        if (s.isBlank()) {
            throw new IllegalArgumentException("Can't parse an empty string");
        }
        return Parser.toIntegerIdentifiers(Parser.split(s, separator));
    }

    static List<IntegerIdentifier> toIntegerIdentifiers(String[] s) {
        Objects.requireNonNull(s, "Can't parse null string array");
        if (s.length == 0) {
            throw new IllegalArgumentException("Can't parse an empty string array");
        }
        ArrayList<IntegerIdentifier> identifiers = new ArrayList<IntegerIdentifier>();
        for (String part : s) {
            identifiers.add(IntegerIdentifier.valueOf(part));
        }
        return identifiers;
    }

    static List<SimpleIdentifier> toIdentifiers(String s, char separator, UseIntegerIdentifiers integersPolicy) {
        Objects.requireNonNull(s, "Can't parse null string");
        if (s.isBlank()) {
            throw new IllegalArgumentException("Can't parse an empty string");
        }
        return Parser.toIdentifiers(Parser.split(s, separator), integersPolicy);
    }

    static List<SimpleIdentifier> toIdentifiers(String[] s, UseIntegerIdentifiers integersPolicy) {
        Objects.requireNonNull(s, "Can't parse null string array");
        if (s.length == 0) {
            throw new IllegalArgumentException("Can't parse an empty string array");
        }
        ArrayList<SimpleIdentifier> identifiers = new ArrayList<SimpleIdentifier>();
        block7: for (String part : s) {
            switch (integersPolicy) {
                case ALWAYS: {
                    identifiers.add(IntegerIdentifier.valueOf(part));
                }
                case NEVER: {
                    identifiers.add(StringIdentifier.valueOf(part));
                }
                case WHEN_POSSIBLE: {
                    try {
                        identifiers.add(IntegerIdentifier.valueOf(part));
                        continue block7;
                    }
                    catch (IllegalArgumentException iae) {
                        if (iae.getCause() != null && NumberFormatException.class.isInstance(iae.getCause())) {
                            identifiers.add(StringIdentifier.valueOf(part));
                            continue block7;
                        }
                        throw iae;
                    }
                }
            }
        }
        return identifiers;
    }

    static SimpleIdentifier toIdentifier(String s, UseIntegerIdentifiers integersPolicy) {
        Objects.requireNonNull(s, "Can't parse null string");
        if (s.isBlank()) {
            throw new IllegalArgumentException("Can't parse an empty string");
        }
        switch (integersPolicy) {
            case ALWAYS: {
                return IntegerIdentifier.valueOf(s);
            }
            case NEVER: {
                return StringIdentifier.valueOf(s);
            }
            case WHEN_POSSIBLE: {
                try {
                    return IntegerIdentifier.valueOf(s);
                }
                catch (IllegalArgumentException iae) {
                    if (iae.getCause() != null && NumberFormatException.class.isInstance(iae.getCause())) {
                        return StringIdentifier.valueOf(s);
                    }
                    throw iae;
                }
            }
        }
        return StringIdentifier.valueOf(s);
    }
}

